package org.gcube.contentmanagement.timeseriesservice.impl.importer;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateImportResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportedItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportedItemsArray;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ImportContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResource;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;


public class ImportFactory {

	private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
	
	private GCUBELog logger = new GCUBELog(ImportFactory.class);
	
	
	/**
	 * 
	 * @param request
	 * @return
	 * @throws GCUBEFault
	 */
	public CreateImportResponse createImportManager(CreateImportRequest request) throws GCUBEFault{
		String id=uuidGen.nextUUID();
		CreateImportResponse response;
		try{
			ImportResource resource= (ImportResource) ImportContext.getPortTypeContext().getWSHome().create(
				ImportContext.getPortTypeContext().makeKey(id), id, request.getTitle(), request.getDescription(), request.getCreator(), request.getPublisher(), request.getRights(), request.getSource(), request.getType());
			response= new CreateImportResponse(resource.getEPR(), resource.getId());
			logger.trace("new resource epr: "+resource.getEPR());
			resource.store();
		}catch(Exception re){ 
			logger.error("error creating importer resource", re);
			throw new GCUBEFault(re,"error creating importer resource");
		}
		return response; 
	}
	
	public EndpointReferenceType openImport(String importId) throws GCUBEFault{
		try{
			ImportResource resource= (ImportResource) ImportContext.getPortTypeContext().getWSHome().find(ImportContext.getPortTypeContext().makeKey(importId));
			return resource.getEPR();
		}catch(Exception re){ 
			logger.error("error opening importer resource", re);
			throw new GCUBEFault(re,"error opening importer resource");
		}
	}
	
	
	/**
	 * 		
	 * @param importId
	 * @return
	 * @throws GCUBEFault
	 */
	public VOID removeImportManager(String importId) throws GCUBEFault{
		try{
			ObjectPersistency.get(ImporterItem.class).deleteByKey(importId);
			ImportContext.getPortTypeContext().getWSHome().remove(ImportContext.getPortTypeContext().makeKey(importId));
		}catch(Exception e){
			logger.error("error removing importer resource", e);
			throw new GCUBEFault(e, "error removing importer resource");
		}
		return new VOID();
	}
	
	
	
	/**
	 * 
	 * @return
	 * @throws GCUBEFault
	 */
	public ImportedItemsArray getImportedItems(String user) throws GCUBEFault{
		ImportedItemsArray iia= new ImportedItemsArray();
		logger.trace("getImportedItems method");
		try {
			
			Iterator<ImporterItem> it = ObjectPersistency.get(ImporterItem.class).getObjectByField("creator", user).iterator();
			List<ImportedItem> importedItems= new ArrayList<ImportedItem>();
			while (it.hasNext()){
				ImporterItem importerItem= it.next();
				if (ServiceContext.getContext().getScope().isEnclosedIn(GCUBEScope.getScope(importerItem.getScope())))
							importedItems.add(createImportItem(importerItem));
			}
			iia.setItems(importedItems.toArray(new ImportedItem[importedItems.size()]));
		}catch(Exception e){
			logger.error("error retrieving ImportedItems",e);
			throw new GCUBEFault(e,"error retrieving ImportedItems");
		}
		return iia;
	}
	
	public ImportedItem getItem(String importerId) throws GCUBEFault{
		try{
			return createImportItem(ObjectPersistency.get(ImporterItem.class).getByKey(importerId));
		}catch(Exception e){logger.error("error getting import item",e); throw new GCUBEFault(e, "item not retrieved");}
	}
		
	private ImportedItem createImportItem(ImporterItem importer) throws Exception{
		ImportedItem item= new ImportedItem();//(String)row.get(3), Util.dateFormatter.format(new Date(((Timestamp)row.get(8)).getTime())), (String)row.get(2), (String)row.get(0) , (Integer) row.get(9), (String)row.get(4), (String)row.get(7), (String)row.get(6), (String)row.get(1), (String) row.get(5));
		item.setCreator(importer.getCreator());
		item.setDescription(importer.getDescription());
		item.setDate(Util.dateFormatter.format(new Date(importer.getDate().getTime())));
		item.setId(importer.getId());
		item.setLenght(importer.getTotalLines());
		item.setPublisher(importer.getPublisher());
		item.setRights(importer.getRights());
		item.setSource(importer.getSource());
		item.setTitle(importer.getTitle());
		item.setType(importer.getType());
		item.setEncoding(importer.getEncoding());
		logger.trace("retrieved imported item: with id: -"+item.getId()+"- and title: "+item.getTitle());
		return item;
	}
	
}
