/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.databases.ConnectionsManager;
import org.gcube.contentmanagement.timeseries.geotools.finder.GeoAreaFinder;
import org.gcube.contentmanagement.timeseries.geotools.finder.TimeSeriesAggregator;
import org.gcube.contentmanagement.timeseries.geotools.representations.GISLayer;

public class AFilter {
    protected boolean isSpaceFilter;
    protected String timeSeriesName;
    protected String ref_country = "ref_country";
    protected String ref_species = "ref_species";
    protected String aggregationColumn;
    protected String informationColumn;
    protected String quantitiesColumn;
    protected GeoAreaFinder geofinder;
    public String valuesColumnName = "maxspeciescountinacell";
    public static final String defaultvaluesColumnName = "maxspeciescountinacell";
    protected float status;
    protected String filtername = "distribution";

    public AFilter(boolean isspacefilter, String timeSeriesName, String mainColumn, String optionalColumn, String quantitiesColumn) {
        this.timeSeriesName = timeSeriesName;
        this.aggregationColumn = mainColumn;
        this.informationColumn = optionalColumn;
        this.quantitiesColumn = quantitiesColumn;
        this.isSpaceFilter = isspacefilter;
    }

    public List<String> findCSquareCodes(String place, List<String> prevCsquares) throws Exception {
        List<String> csquares = this.geofinder.findCSquareCodes(place, prevCsquares);
        return csquares;
    }

    public String getRef_country() {
        return this.ref_country;
    }

    public void setRef_country(String ref_country) {
        if (ref_country != null) {
            this.ref_country = ref_country;
        }
    }

    public String getRef_species() {
        return this.ref_species;
    }

    public void setRef_species(String ref_species) {
        if (ref_species != null) {
            this.ref_species = ref_species;
        }
    }

    public void setSpaceFilter(boolean isSpaceFilter) {
        this.isSpaceFilter = isSpaceFilter;
    }

    public boolean isSpaceFilter() {
        return this.isSpaceFilter;
    }

    public String getTimeSeriesName() {
        return this.timeSeriesName;
    }

    public void setTimeSeriesName(String timeSeriesName) {
        this.timeSeriesName = timeSeriesName;
    }

    public String getAggregationColumn() {
        return this.aggregationColumn;
    }

    public void setAggregationColumn(String aggregationColumn) {
        this.aggregationColumn = aggregationColumn;
    }

    public String getInformationColumn() {
        return this.informationColumn;
    }

    public void setInformationColumn(String informationColumn) {
        this.informationColumn = informationColumn;
    }

    public String getQuantitiesColumn() {
        return this.quantitiesColumn;
    }

    public void setQuantitiesColumn(String quantitiesColumn) {
        this.quantitiesColumn = quantitiesColumn;
    }

    public void initFilter() {
    }

    public List<String> postFilterSquare(List<String> csquares) {
        return csquares;
    }

    public List<GISLayer> filter(GISLayer previousGisLayer, ConnectionsManager connectionsManager, GeoAreaFinder geofind) throws Exception {
        String name = this.getAggregationColumn();
        String timeseriesname = this.getTimeSeriesName();
        String placesColumn = this.getAggregationColumn();
        String quantitiesColumn = this.getQuantitiesColumn();
        if (timeseriesname == null || placesColumn == null || quantitiesColumn == null) {
            throw new Exception("Inconsistent Values");
        }
        if (previousGisLayer != null) {
            name = previousGisLayer.getLayerName() + "_" + name;
        }
        String layername = (placesColumn.substring(0, Math.min(10, placesColumn.length())) + "_" + UUID.randomUUID()).replace("-", "_");
        GISLayer layer = new GISLayer(layername);
        layer.setLayerTitle(this.filtername);
        this.geofinder = geofind == null ? new GeoAreaFinder(connectionsManager, this.ref_country) : geofind;
        TimeSeriesAggregator aggregator = new TimeSeriesAggregator(connectionsManager);
        Map<String, String> aggregation = aggregator.aggregateTimeSeries(placesColumn, quantitiesColumn, timeseriesname);
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        float totalNumber = aggregation.size();
        int counter = 0;
        for (String place : aggregation.keySet()) {
            List<String> csquares;
            AnalysisLogger.getLogger().warn((Object)("FAOAreaFilter->PLACE:" + place));
            String quant = aggregation.get(place);
            AnalysisLogger.getLogger().trace((Object)("FAOAreaFilter->QUANTITY:" + quant));
            Double value = 0.0;
            try {
                value = Double.parseDouble(quant);
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (value > max) {
                max = value;
            }
            if (value < min) {
                min = value;
            }
            List<String> prevCsquares = null;
            if (previousGisLayer != null) {
                prevCsquares = previousGisLayer.getCsquareCodes();
            }
            if ((csquares = this.findCSquareCodes(place, prevCsquares)).size() > 0) {
                layer.appendListofSquares(csquares, value, place);
            }
            this.status = (float)(++counter) / totalNumber;
        }
        if (max == min) {
            max += 1.0;
        }
        layer.setMax(max);
        layer.setMin(min);
        layer.setValuesColumnName(this.valuesColumnName);
        AnalysisLogger.getLogger().trace((Object)("FAOAreaFilter->VALUES - MIN:" + min + " MAX:" + max));
        ArrayList<GISLayer> singletonlayers = new ArrayList<GISLayer>();
        singletonlayers.add(layer);
        this.status = 100.0f;
        return singletonlayers;
    }

    public void setStatus(float status) {
        this.status = status;
    }

    public float getStatus() {
        return this.status;
    }
}

