/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.representations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;

public class GISLayer {
    private String layerName;
    private String layerTitle;
    private String preferredStyleName;
    private List<String> csquarecodes = new ArrayList<String>();
    private List<String> geometries = new ArrayList<String>();
    private Map<String, String> squaresVsValues;
    private Map<String, String> squaresVsOtherInfo;
    private List<Double> values = new ArrayList<Double>();
    private List<String> infos = new ArrayList<String>();
    private boolean isNotEmpty;
    private String valuesColumnName;
    private double min;
    private double max;

    public void forceNotEmpty() {
        this.isNotEmpty = true;
    }

    public boolean isEmpty() {
        return !this.isNotEmpty && (this.csquarecodes == null || this.csquarecodes.size() == 0);
    }

    public List<String> getInfos() {
        return this.infos;
    }

    public void setInfos(List<String> infos) {
        this.infos = infos;
    }

    public List<Double> getValues() {
        return this.values;
    }

    public void setValues(List<Double> values) {
        this.values = values;
    }

    public List<String> getGeometries() {
        return this.geometries;
    }

    public GISLayer(String name) {
        this.layerName = name;
        this.squaresVsValues = new HashMap<String, String>();
        this.squaresVsOtherInfo = new HashMap<String, String>();
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.isNotEmpty = false;
    }

    public void appendListofSquares(List<String> csquareCodes, Double valueForAll, String information) {
        for (String square : csquareCodes) {
            this.csquarecodes.add(square);
            this.values.add(valueForAll);
            this.infos.add(information);
        }
    }

    public void mergeGISLayers(List<GISLayer> layers) {
        for (GISLayer layer : layers) {
            List<String> csquares = layer.getCsquareCodes();
            List<Double> values = layer.getValues();
            List<String> infoss = layer.getInfos();
            if (this.layerTitle == null || this.layerTitle.length() == 0) {
                this.layerTitle = layer.getLayerTitle();
            }
            this.appendListofSquares(csquares, values, infoss);
        }
        AnalysisLogger.getLogger().warn((Object)"continuing to merge");
        for (String key : this.squaresVsValues.keySet()) {
            String svalue = this.squaresVsValues.get(key);
            if (svalue == null) {
                svalue = "0";
            }
            double value = Double.parseDouble(svalue);
            this.csquarecodes.add(key);
            this.values.add(value);
            String info = this.squaresVsOtherInfo.get(key);
            if (info == null) {
                info = "";
            }
            this.infos.add(info);
        }
    }

    public void appendListofSquares(List<String> csquareCodes, List<Double> values, List<String> infos) {
        int i = 0;
        for (String square : csquareCodes) {
            String inf;
            String information;
            String svalue = this.squaresVsValues.get(square);
            double value = values.get(i);
            if (svalue != null) {
                double prevval = Double.parseDouble(svalue);
                value += prevval;
            }
            if ((information = this.squaresVsOtherInfo.get(square)) == null) {
                information = "";
            }
            if ((inf = infos.get(i)) != null && inf.length() > 0) {
                information = information + inf + "; ";
            }
            this.squaresVsValues.put(square, "" + value);
            this.squaresVsOtherInfo.put(square, information);
            if (value > this.max) {
                this.max = value;
            }
            if (value < this.min) {
                this.min = value;
            }
            ++i;
        }
        if (this.max == this.min) {
            this.max = this.min + 1.0;
        }
    }

    public void addTriple(String csquarecode, String geom, Double prob) {
        this.csquarecodes.add(csquarecode);
        this.geometries.add(geom);
        this.values.add(prob);
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public List<String> getCsquareCodes() {
        return this.csquarecodes;
    }

    public void setGeometries(List<String> geometries) {
        this.geometries = geometries;
    }

    public void setValuesColumnName(String valuesColumnName) {
        this.valuesColumnName = valuesColumnName;
    }

    public String getValuesColumnName() {
        return this.valuesColumnName;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMax() {
        return this.max;
    }

    public String getPreferredStyleName() {
        return this.preferredStyleName;
    }

    public void setPreferredStyleName(String preferredStyleName) {
        this.preferredStyleName = preferredStyleName;
    }

    public String getLayerTitle() {
        return this.layerTitle;
    }

    public void setLayerTitle(String layerTitle) {
        this.layerTitle = layerTitle;
    }
}

