/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.jcache.provider;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import org.cache2k.CacheEntry;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.CacheType;
import org.cache2k.configuration.CustomizationReferenceSupplier;
import org.cache2k.core.Cache2kCoreProviderImpl;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.InternalCache2kBuilder;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.ExceptionInformation;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.jcache.ExtendedConfiguration;
import org.cache2k.jcache.ExtendedMutableConfiguration;
import org.cache2k.jcache.JCacheConfiguration;
import org.cache2k.jcache.provider.JCacheAdapter;
import org.cache2k.jcache.provider.JCacheManagerAdapter;
import org.cache2k.jcache.provider.TouchyJCacheAdapter;
import org.cache2k.jcache.provider.event.EventHandling;
import org.cache2k.jcache.provider.event.EventHandlingImpl;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.CopyCacheProxy;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.ObjectTransformer;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.RuntimeCopyTransformer;
import org.cache2k.jcache.provider.generic.storeByValueSimulation.SimpleObjectCopyFactory;

public class JCacheBuilder<K, V> {
    private String name;
    private JCacheManagerAdapter manager;
    private boolean cache2kConfigurationWasProvided = false;
    private CompleteConfiguration<K, V> config;
    private Cache2kConfiguration<K, V> cache2kConfiguration;
    private JCacheConfiguration extraConfiguration = JCACHE_DEFAULTS;
    private CacheType<K> keyType;
    private CacheType<V> valueType;
    private ExpiryPolicy expiryPolicy;
    private Cache<K, V> createdCache;
    private EventHandling<K, V> eventHandling;
    private boolean needsTouchyWrapper;
    private static final JCacheConfiguration JCACHE_DEFAULTS = new JCacheConfiguration.Builder().copyAlwaysIfRequested(true).supportOnlineListenerAttachment(true).buildConfigurationSection();
    private static final JCacheConfiguration CACHE2K_DEFAULTS = new JCacheConfiguration.Builder().copyAlwaysIfRequested(false).supportOnlineListenerAttachment(false).buildConfigurationSection();

    public JCacheBuilder(String _name, JCacheManagerAdapter _manager) {
        this.name = _name;
        this.manager = _manager;
    }

    public void setConfiguration(Configuration<K, V> cfg) {
        if (cfg instanceof CompleteConfiguration) {
            this.config = (CompleteConfiguration)cfg;
            if (cfg instanceof ExtendedConfiguration) {
                this.cache2kConfiguration = ((ExtendedConfiguration)cfg).getCache2kConfiguration();
                if (this.cache2kConfiguration != null) {
                    if (this.cache2kConfiguration.getName() != null && !this.cache2kConfiguration.getName().equals(this.name)) {
                        throw new IllegalArgumentException("cache name mismatch.");
                    }
                    this.cache2kConfigurationWasProvided = true;
                }
            }
        } else {
            MutableConfiguration<K, V> _cfgCopy = new MutableConfiguration<K, V>();
            _cfgCopy.setTypes(cfg.getKeyType(), cfg.getValueType());
            _cfgCopy.setStoreByValue(cfg.isStoreByValue());
            this.config = _cfgCopy;
        }
        if (this.cache2kConfiguration == null) {
            this.cache2kConfiguration = CacheManagerImpl.PROVIDER.getDefaultConfiguration(this.manager.getCache2kManager());
            if (cfg instanceof ExtendedMutableConfiguration) {
                ((ExtendedMutableConfiguration)cfg).setCache2kConfiguration(this.cache2kConfiguration);
            }
        }
        this.cache2kConfiguration.setName(this.name);
        Cache2kCoreProviderImpl.CACHE_CONFIGURATION_PROVIDER.augmentConfiguration(this.manager.getCache2kManager(), this.cache2kConfiguration);
        this.cache2kConfigurationWasProvided |= this.cache2kConfiguration.isExternalConfigurationPresent();
        if (this.cache2kConfigurationWasProvided) {
            this.extraConfiguration = CACHE2K_DEFAULTS;
            JCacheConfiguration _extraConfigurationSpecified = this.cache2kConfiguration.getSections().getSection(JCacheConfiguration.class);
            if (_extraConfigurationSpecified != null) {
                this.extraConfiguration = _extraConfigurationSpecified;
            }
        }
    }

    public Cache<K, V> build() {
        this.setupTypes();
        this.setupDefaults();
        this.setupExceptionPropagator();
        this.setupCacheThrough();
        this.setupExpiryPolicy();
        this.setupEventHandling();
        this.buildAdapterCache();
        this.wrapForExpiryPolicy();
        this.wrapIfCopyIsNeeded();
        return this.createdCache;
    }

    public boolean isStatisticsEnabled() {
        return this.config.isStatisticsEnabled() || this.extraConfiguration.isEnableStatistics();
    }

    public boolean isManagementEnabled() {
        return this.config.isManagementEnabled() || this.extraConfiguration.isEnableManagement();
    }

    JCacheConfiguration getExtraConfiguration() {
        return this.extraConfiguration;
    }

    private void setupTypes() {
        if (!this.cache2kConfigurationWasProvided) {
            this.cache2kConfiguration.setKeyType(this.config.getKeyType());
            this.cache2kConfiguration.setValueType(this.config.getValueType());
        } else {
            if (this.cache2kConfiguration.getKeyType() == null) {
                this.cache2kConfiguration.setKeyType(this.config.getKeyType());
            }
            if (this.cache2kConfiguration.getValueType() == null) {
                this.cache2kConfiguration.setValueType(this.config.getValueType());
            }
        }
        this.keyType = this.cache2kConfiguration.getKeyType();
        this.valueType = this.cache2kConfiguration.getValueType();
        if (!this.config.getKeyType().equals(Object.class) && !this.config.getKeyType().equals(this.keyType.getType())) {
            throw new IllegalArgumentException("Key type mismatch between JCache and cache2k configuration");
        }
        if (!this.config.getValueType().equals(Object.class) && !this.config.getValueType().equals(this.valueType.getType())) {
            throw new IllegalArgumentException("Value type mismatch between JCache and cache2k configuration");
        }
    }

    private void setupDefaults() {
        if (!this.cache2kConfigurationWasProvided) {
            this.cache2kConfiguration.setSharpExpiry(true);
        }
    }

    private void setupExceptionPropagator() {
        if (this.cache2kConfiguration.getExceptionPropagator() != null) {
            return;
        }
        this.cache2kConfiguration.setExceptionPropagator(new CustomizationReferenceSupplier(new ExceptionPropagator<K>(){

            @Override
            public RuntimeException propagateException(Object key, ExceptionInformation exceptionInformation) {
                return new CacheLoaderException("propagate previous loader exception", exceptionInformation.getException());
            }
        }));
    }

    private void setupCacheThrough() {
        if (this.config.getCacheLoaderFactory() != null) {
            final CacheLoader<K, V> clf = this.config.getCacheLoaderFactory().create();
            this.cache2kConfiguration.setAdvancedLoader(new CustomizationReferenceSupplier(new CloseableLoader(){

                @Override
                public void close() throws IOException {
                    if (clf instanceof Closeable) {
                        ((Closeable)((Object)clf)).close();
                    }
                }

                @Override
                public V load(K key, long currentTime, CacheEntry<K, V> currentEntry) {
                    return clf.load(key);
                }
            }));
        }
        if (this.config.getCacheWriterFactory() != null) {
            final javax.cache.integration.CacheWriter<K, V> cw = this.config.getCacheWriterFactory().create();
            this.cache2kConfiguration.setWriter(new CustomizationReferenceSupplier(new CloseableWriter(){

                @Override
                public void write(final K key, final V value) {
                    Cache.Entry ce = new Cache.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return value;
                        }

                        @Override
                        public <T> T unwrap(Class<T> clazz) {
                            throw new UnsupportedOperationException("unwrap entry not supported");
                        }
                    };
                    cw.write(ce);
                }

                @Override
                public void delete(Object key) {
                    cw.delete(key);
                }

                @Override
                public void close() throws IOException {
                    if (cw instanceof Closeable) {
                        ((Closeable)((Object)cw)).close();
                    }
                }
            }));
        }
    }

    private void setupExpiryPolicy() {
        if (this.cache2kConfiguration.getExpiryPolicy() != null) {
            org.cache2k.expiry.ExpiryPolicy<K, V> ep0;
            try {
                ep0 = this.cache2kConfiguration.getExpiryPolicy().supply(this.manager.getCache2kManager());
            }
            catch (Exception ex) {
                throw new CacheException("couldn't initialize expiry policy", ex);
            }
            final org.cache2k.expiry.ExpiryPolicy<K, V> ep = ep0;
            this.cache2kConfiguration.setExpiryPolicy(new CustomizationReferenceSupplier(new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                @Override
                public long calculateExpiryTime(K key, V value, long loadTime, CacheEntry<K, V> oldEntry) {
                    if (value == null) {
                        return 0L;
                    }
                    return ep.calculateExpiryTime(key, value, loadTime, oldEntry);
                }
            }));
            return;
        }
        if (this.config.getExpiryPolicyFactory() != null) {
            this.expiryPolicy = this.config.getExpiryPolicyFactory().create();
        }
        if (this.expiryPolicy == null || this.expiryPolicy instanceof EternalExpiryPolicy) {
            this.cache2kConfiguration.setExpiryPolicy(new CustomizationReferenceSupplier(new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                @Override
                public long calculateExpiryTime(K key, V value, long loadTime, CacheEntry<K, V> oldEntry) {
                    if (value == null) {
                        return 0L;
                    }
                    return Long.MAX_VALUE;
                }
            }));
            return;
        }
        if (this.expiryPolicy instanceof ModifiedExpiryPolicy) {
            Duration d = this.expiryPolicy.getExpiryForCreation();
            final long _millisDuration = d.getTimeUnit().toMillis(d.getDurationAmount());
            if (_millisDuration == 0L) {
                this.cache2kConfiguration.setExpiryPolicy(new CustomizationReferenceSupplier(new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                    @Override
                    public long calculateExpiryTime(K key, V value, long loadTime, CacheEntry<K, V> oldEntry) {
                        return 0L;
                    }
                }));
                return;
            }
            this.cache2kConfiguration.setExpiryPolicy(new CustomizationReferenceSupplier(new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                @Override
                public long calculateExpiryTime(K key, V value, long loadTime, CacheEntry<K, V> oldEntry) {
                    if (value == null) {
                        return 0L;
                    }
                    return loadTime + _millisDuration;
                }
            }));
            return;
        }
        if (this.expiryPolicy instanceof CreatedExpiryPolicy) {
            this.cache2kConfiguration.setEternal(true);
            Duration d = this.expiryPolicy.getExpiryForCreation();
            final long _millisDuration = d.getTimeUnit().toMillis(d.getDurationAmount());
            if (_millisDuration == 0L) {
                this.cache2kConfiguration.setExpiryPolicy(new CustomizationReferenceSupplier(new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                    @Override
                    public long calculateExpiryTime(K key, V value, long loadTime, CacheEntry<K, V> oldEntry) {
                        return 0L;
                    }
                }));
                return;
            }
            this.cache2kConfiguration.setExpiryPolicy(new CustomizationReferenceSupplier(new org.cache2k.expiry.ExpiryPolicy<K, V>(){

                @Override
                public long calculateExpiryTime(K key, V value, long loadTime, CacheEntry<K, V> oldEntry) {
                    if (value == null) {
                        return 0L;
                    }
                    if (oldEntry == null) {
                        return loadTime + _millisDuration;
                    }
                    return -1L;
                }
            }));
            return;
        }
        this.needsTouchyWrapper = true;
        this.cache2kConfiguration.setExpiryPolicy(new CustomizationReferenceSupplier(new TouchyJCacheAdapter.ExpiryPolicyAdapter(this.expiryPolicy)));
    }

    private void setupEventHandling() {
        if (!(this.config.getCacheEntryListenerConfigurations() != null && this.config.getCacheEntryListenerConfigurations().iterator().hasNext() || this.extraConfiguration.isSupportOnlineListenerAttachment())) {
            this.eventHandling = EventHandling.DISABLED;
            return;
        }
        EventHandlingImpl<K, V> _eventHandling = new EventHandlingImpl<K, V>(this.manager, Executors.newCachedThreadPool());
        _eventHandling.addInternalListenersToCache2kConfiguration(this.cache2kConfiguration);
        for (CacheEntryListenerConfiguration<K, V> cfg : this.config.getCacheEntryListenerConfigurations()) {
            _eventHandling.registerListener(cfg);
        }
        this.eventHandling = _eventHandling;
        this.cache2kConfiguration.getCacheClosedListeners().add(new CustomizationReferenceSupplier(_eventHandling));
    }

    private void buildAdapterCache() {
        this.createdCache = new JCacheAdapter<K, V>(this.manager, new InternalCache2kBuilder<K, V>(this.cache2kConfiguration, this.manager.getCache2kManager()).buildAsIs(), this.keyType.getType(), this.valueType.getType(), this.config.isStoreByValue(), this.config.isReadThrough(), this.config.getCacheLoaderFactory() != null, this.eventHandling);
    }

    private void wrapForExpiryPolicy() {
        if (this.needsTouchyWrapper) {
            this.createdCache = new TouchyJCacheAdapter((JCacheAdapter)this.createdCache, this.expiryPolicy);
        }
    }

    private void wrapIfCopyIsNeeded() {
        if (this.extraConfiguration.isCopyAlwaysIfRequested() && this.config.isStoreByValue()) {
            ObjectTransformer<K, K> _keyTransformer = this.createCopyTransformer(this.keyType);
            ObjectTransformer<V, V> _valueTransformer = this.createCopyTransformer(this.valueType);
            this.createdCache = new CopyCacheProxy<K, V>(this.createdCache, _keyTransformer, _valueTransformer);
        }
    }

    private <T> ObjectTransformer<T, T> createCopyTransformer(CacheType<T> _type) {
        SimpleObjectCopyFactory f = new SimpleObjectCopyFactory();
        RuntimeCopyTransformer _keyTransformer = f.createCopyTransformer(_type.getType(), this.manager.getClassLoader());
        if (_keyTransformer == null) {
            _keyTransformer = new RuntimeCopyTransformer(this.manager.getClassLoader());
        }
        return _keyTransformer;
    }

    abstract class CloseableWriter
    extends CacheWriter<K, V>
    implements Closeable {
        CloseableWriter() {
        }
    }

    abstract class CloseableLoader
    extends AdvancedCacheLoader<K, V>
    implements Closeable {
        CloseableLoader() {
        }
    }
}

