/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.fs;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class FSInputStream
extends InputStream {
    private boolean closed = false;
    BlockingQueue<Byte> q = new LinkedBlockingQueue<Byte>(20000);
    public int byteRead = 0;
    public int bytegiven = 0;

    protected synchronized void add(byte[] buf) {
        for (byte b : buf) {
            try {
                this.q.put(b);
                ++this.byteRead;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public int read() throws IOException {
        try {
            Byte retrievedValue;
            while ((retrievedValue = this.q.poll(2L, TimeUnit.SECONDS)) == null && !this.closed) {
            }
            if (this.closed && retrievedValue == null) {
                return -1;
            }
            int value = retrievedValue & 0xFF;
            ++this.bytegiven;
            return value;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public int available() {
        return this.q.size();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    public boolean isClosed() {
        return this.closed;
    }
}

