/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.concurrent.atomic.AtomicLong;
import org.cache2k.Cache;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.CollisionInfo;
import org.cache2k.core.Entry;
import org.cache2k.core.HeapCache;
import org.cache2k.core.concurrency.Job;
import org.cache2k.core.concurrency.Locks;
import org.cache2k.core.concurrency.OptimisticLock;

public class Hash2<K, V> {
    private static final int LOCK_SEGMENTS;
    private static final int LOCK_MASK;
    private volatile int clearOrCloseCount = 0;
    private long segmentMaxFill;
    private Entry<K, V>[] entries;
    private final OptimisticLock[] locks = new OptimisticLock[LOCK_SEGMENTS];
    private final AtomicLong[] segmentSize;
    private final Cache cache;

    public Hash2(Cache _cache) {
        int i;
        for (i = 0; i < LOCK_SEGMENTS; ++i) {
            this.locks[i] = Locks.newOptimistic();
        }
        this.segmentSize = new AtomicLong[LOCK_SEGMENTS];
        for (i = 0; i < LOCK_SEGMENTS; ++i) {
            this.segmentSize[i] = new AtomicLong();
        }
        this.initArray();
        this.cache = _cache;
    }

    private void initArray() {
        int len = Math.max(HeapCache.TUNABLE.initialHashSize, LOCK_SEGMENTS * 4);
        this.entries = new Entry[len];
        this.calcMaxFill();
    }

    private void calcMaxFill() {
        this.segmentMaxFill = this.entries.length * HeapCache.TUNABLE.hashLoadPercent / 100 / LOCK_SEGMENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<K, V> lookup(K key, int _hash, int _keyValue) {
        OptimisticLock[] _locks = this.locks;
        int si = _hash & LOCK_MASK;
        OptimisticLock l = _locks[si];
        long _stamp = l.tryOptimisticRead();
        Entry<K, V>[] tab = this.entries;
        if (tab == null) {
            throw new CacheClosedException(this.cache);
        }
        int n = tab.length;
        int _mask = n - 1;
        int idx = _hash & _mask;
        Entry e = tab[idx];
        while (e != null) {
            if (e.hashCode == _keyValue && this.keyObjIsEqual(key, e)) {
                return e;
            }
            e = e.another;
        }
        if (l.validate(_stamp)) {
            return null;
        }
        _stamp = l.readLock();
        try {
            tab = this.entries;
            if (tab == null) {
                throw new CacheClosedException(this.cache);
            }
            n = tab.length;
            _mask = n - 1;
            idx = _hash & _mask;
            e = tab[idx];
            while (e != null) {
                if (e.hashCode == _keyValue && this.keyObjIsEqual(key, e)) {
                    Entry entry = e;
                    return entry;
                }
                e = e.another;
            }
            Entry<K, V> entry = null;
            return entry;
        }
        finally {
            l.unlockRead(_stamp);
        }
    }

    protected boolean keyObjIsEqual(K key, Entry e) {
        Object ek = e.getKeyObj();
        return ek == key || ek.equals(key);
    }

    public Entry<K, V> insertWithinLock(Entry<K, V> e, int _hash, int _keyValue) {
        Object key = e.getKeyObj();
        int si = _hash & LOCK_MASK;
        Entry<K, V>[] tab = this.entries;
        if (tab == null) {
            throw new CacheClosedException(this.cache);
        }
        int n = tab.length;
        int _mask = n - 1;
        int idx = _hash & _mask;
        Entry f = tab[idx];
        while (f != null) {
            Object ek;
            if (f.hashCode == _keyValue && ((ek = f.getKeyObj()) == key || ek.equals(key))) {
                return f;
            }
            f = f.another;
        }
        e.another = tab[idx];
        tab[idx] = e;
        this.segmentSize[si].incrementAndGet();
        return e;
    }

    public void checkExpand(int _hash) {
        int si = _hash & LOCK_MASK;
        long _size = this.segmentSize[si].get();
        if (_size > this.segmentMaxFill) {
            this.eventuallyExpand(si);
        }
    }

    public OptimisticLock getSegmentLock(int _hash) {
        return this.locks[_hash & LOCK_MASK];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Entry<K, V> e) {
        int _hash = this.modifiedHashCode(e.hashCode);
        OptimisticLock[] _locks = this.locks;
        int si = _hash & LOCK_MASK;
        OptimisticLock l = _locks[si];
        long _stamp = l.writeLock();
        try {
            Entry<K, V>[] tab = this.entries;
            if (tab == null) {
                throw new CacheClosedException(this.cache);
            }
            int n = tab.length;
            int _mask = n - 1;
            int idx = _hash & _mask;
            Entry f = tab[idx];
            if (f == e) {
                tab[idx] = f.another;
                this.segmentSize[si].decrementAndGet();
                boolean bl = true;
                return bl;
            }
            while (f != null) {
                Entry _another = f.another;
                if (_another == e) {
                    f.another = _another.another;
                    this.segmentSize[si].decrementAndGet();
                    boolean bl = true;
                    return bl;
                }
                f = _another;
            }
        }
        finally {
            l.unlockWrite(_stamp);
        }
        return false;
    }

    public boolean removeWithinLock(Entry<K, V> e, int _hash) {
        int si = _hash & LOCK_MASK;
        Entry<K, V>[] tab = this.entries;
        if (tab == null) {
            throw new CacheClosedException(this.cache);
        }
        int n = tab.length;
        int _mask = n - 1;
        int idx = _hash & _mask;
        Entry f = tab[idx];
        if (f == e) {
            tab[idx] = f.another;
            this.segmentSize[si].decrementAndGet();
            return true;
        }
        while (f != null) {
            Entry _another = f.another;
            if (_another == e) {
                f.another = _another.another;
                this.segmentSize[si].decrementAndGet();
                return true;
            }
            f = _another;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventuallyExpand(int _segmentIndex) {
        long[] _stamps = this.lockAll();
        try {
            long _size = this.segmentSize[_segmentIndex].get();
            if (_size <= this.segmentMaxFill) {
                return;
            }
            this.rehash();
        }
        finally {
            this.unlockAll(_stamps);
        }
    }

    private long[] lockAll() {
        OptimisticLock[] _locks = this.locks;
        int sn = _locks.length;
        long[] _stamps = new long[this.locks.length];
        for (int i = 0; i < sn; ++i) {
            OptimisticLock l = _locks[i];
            _stamps[i] = l.writeLock();
        }
        return _stamps;
    }

    private void unlockAll(long[] _stamps) {
        OptimisticLock[] _locks = this.locks;
        int sn = _locks.length;
        for (int i = 0; i < sn; ++i) {
            _locks[i].unlockWrite(_stamps[i]);
        }
    }

    protected int modifiedHashCode(int hc) {
        return hc;
    }

    private void rehash() {
        Entry<K, V>[] src = this.entries;
        if (src == null) {
            throw new CacheClosedException(this.cache);
        }
        int sl = src.length;
        int n = sl * 2;
        int _mask = n - 1;
        Entry[] tab = new Entry[n];
        long _count = 0L;
        for (int i = 0; i < sl; ++i) {
            Entry e = src[i];
            while (e != null) {
                ++_count;
                Entry _next = e.another;
                int idx = this.modifiedHashCode(e.hashCode) & _mask;
                e.another = tab[idx];
                tab[idx] = e;
                e = _next;
            }
        }
        this.entries = tab;
        this.calcMaxFill();
    }

    public long getSize() {
        long sum = 0L;
        for (AtomicLong al : this.segmentSize) {
            sum += al.get();
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runTotalLocked(Job<T> j) {
        long[] _stamps = this.lockAll();
        try {
            T t = j.call();
            return t;
        }
        finally {
            this.unlockAll(_stamps);
        }
    }

    public void clearWhenLocked() {
        for (AtomicLong aSegmentSize : this.segmentSize) {
            aSegmentSize.set(0L);
        }
        ++this.clearOrCloseCount;
        this.initArray();
    }

    public int getClearOrCloseCount() {
        return this.clearOrCloseCount;
    }

    public void close() {
        ++this.clearOrCloseCount;
        this.entries = null;
    }

    /*
     * WARNING - void declaration
     */
    public void calcHashCollisionInfo(CollisionInfo inf) {
        for (Entry<K, V> entry : this.entries) {
            void var5_8;
            Entry entry2;
            if (entry == null || (entry2 = entry.another) == null) continue;
            ++inf.collisionSlotCnt;
            int _size = 1;
            while (var5_8 != null) {
                ++inf.collisionCnt;
                Entry entry3 = var5_8.another;
                ++_size;
            }
            if (inf.longestCollisionSize >= _size) continue;
            inf.longestCollisionSize = _size;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long calcEntryCount() {
        long _count = 0L;
        for (Entry<K, V> entry : this.entries) {
            void var6_5;
            while (var6_5 != null) {
                ++_count;
                Entry entry2 = var6_5.another;
            }
        }
        return _count;
    }

    public Entry<K, V>[] getEntries() {
        return this.entries;
    }

    static {
        int _ncpu = Runtime.getRuntime().availableProcessors();
        LOCK_SEGMENTS = 2 << 31 - Integer.numberOfLeadingZeros(_ncpu);
        LOCK_MASK = LOCK_SEGMENTS - 1;
    }
}

