/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.serverSide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.cache2k.Cache;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.HealthInfoElement;
import org.cache2k.core.InternalCache;
import org.cache2k.jmx.CacheManagerMXBean;

public class ManagerMXBeanImpl
implements CacheManagerMXBean {
    private final CacheManagerImpl manager;

    public ManagerMXBeanImpl(CacheManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public String getHealthStatus() {
        ArrayList<HealthInfoElement> li = new ArrayList<HealthInfoElement>();
        for (Cache c : this.manager.getActiveCaches()) {
            InternalCache ic = (InternalCache)c;
            li.addAll(ic.getInfo().getHealth());
        }
        this.sortHealthInfoList(li);
        return ManagerMXBeanImpl.constructHealthString(li);
    }

    void sortHealthInfoList(List<HealthInfoElement> li) {
        Collections.sort(li, new Comparator<HealthInfoElement>(){

            @Override
            public int compare(HealthInfoElement o1, HealthInfoElement o2) {
                if (!o1.getLevel().equals(o2.getLevel())) {
                    return "FAILURE".equals(o1.getLevel()) ? -1 : 1;
                }
                return o1.getCache().getName().compareTo(o2.getCache().getName());
            }
        });
    }

    static String constructHealthString(List<HealthInfoElement> _sortedList) {
        if (_sortedList.isEmpty()) {
            return "ok";
        }
        boolean _comma = false;
        StringBuilder sb = new StringBuilder();
        for (HealthInfoElement hi : _sortedList) {
            if (_comma) {
                sb.append("; ");
            }
            sb.append(hi.getLevel()).append(": ").append("[").append(hi.getCache().getName() + "] ").append(hi.getMessage());
            _comma = true;
        }
        return sb.toString();
    }

    @Override
    public void clear() {
        this.manager.clear();
    }

    @Override
    public String getVersion() {
        return this.manager.getVersion();
    }

    @Override
    public String getBuildNumber() {
        return "not used";
    }
}

