/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

import jnr.ffi.NativeType;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.posix.util.Platform;

public abstract class BaseStruct
extends Struct {
    protected BaseStruct(Runtime runtime) {
        super(runtime);
    }

    protected final <T> Func<T> func(Class<T> closureClass) {
        return new Func<T>(closureClass);
    }

    public class __off64_t
    extends Struct.Signed64 {
    }

    public class __time_t
    extends Struct.SignedLong {
    }

    public class fsfilcnt64_t
    extends Struct.NumberField {
        public fsfilcnt64_t() {
            super(Platform.IS_MAC ? NativeType.UINT : NativeType.SLONGLONG);
        }

        public fsfilcnt64_t(Struct.Offset offset) {
            super(Platform.IS_MAC ? NativeType.UINT : NativeType.SLONGLONG, offset);
        }

        public long get() {
            return Platform.IS_MAC ? (long)this.getMemory().getInt(this.offset()) : this.getMemory().getLongLong(this.offset());
        }

        @Override
        public void set(Number value) {
            if (Platform.IS_MAC) {
                this.getMemory().putInt(this.offset(), value.intValue());
            } else {
                this.getMemory().putLongLong(this.offset(), value.longValue());
            }
        }

        @Override
        public int intValue() {
            return (int)this.get();
        }

        @Override
        public long longValue() {
            return this.get();
        }

        @Override
        public String toString() {
            return Long.toString(this.get());
        }
    }

    public class fsblkcnt64_t
    extends Struct.NumberField {
        public fsblkcnt64_t() {
            super(Platform.IS_MAC ? NativeType.UINT : NativeType.SLONGLONG);
        }

        public fsblkcnt64_t(Struct.Offset offset) {
            super(Platform.IS_MAC ? NativeType.UINT : NativeType.SLONGLONG, offset);
        }

        public long get() {
            return Platform.IS_MAC ? (long)this.getMemory().getInt(this.offset()) : this.getMemory().getLongLong(this.offset());
        }

        @Override
        public void set(Number value) {
            if (Platform.IS_MAC) {
                this.getMemory().putInt(this.offset(), value.intValue());
            } else {
                this.getMemory().putLongLong(this.offset(), value.longValue());
            }
        }

        @Override
        public int intValue() {
            return (int)this.get();
        }

        @Override
        public long longValue() {
            return this.get();
        }

        @Override
        public String toString() {
            return Long.toString(this.get());
        }
    }

    public class Func<T>
    extends Struct.AbstractMember {
        private final Class<? extends T> closureClass;
        private T instance;

        public Func(Class<? extends T> closureClass) {
            super(NativeType.ADDRESS);
            this.closureClass = closureClass;
        }

        public final void set(T value) {
            this.instance = value;
            this.getMemory().putPointer(this.offset(), BaseStruct.this.getRuntime().getClosureManager().getClosurePointer(this.closureClass, this.instance));
        }
    }
}

