/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.stubs.jaxws;

import jakarta.xml.ws.EndpointReference;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class GCoreEndpointReference {
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final String addressLocalName = "Address";
    private static final String keyLocalName = "ResourceKey";
    String address;
    Element key;

    GCoreEndpointReference(EndpointReference reference) {
        this(GCoreEndpointReference.serialise(reference));
    }

    GCoreEndpointReference(String reference) {
        try {
            Document document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(reference)));
            NodeList addresses = document.getElementsByTagNameNS("*", addressLocalName);
            if (addresses.getLength() == 0) {
                throw new RuntimeException("reference does not contain an address");
            }
            this.address = addresses.item(0).getTextContent();
            NodeList keys = document.getElementsByTagNameNS("*", keyLocalName);
            if (keys.getLength() > 1) {
                throw new RuntimeException("reference contains " + keys.getLength() + " resource key(s)");
            }
            if (keys.getLength() == 1) {
                this.key = (Element)keys.item(0);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("reference is not a gCore reference", e);
        }
    }

    public String toString() {
        return this.address + ":" + this.key.getTextContent();
    }

    private static String serialise(EndpointReference reference) {
        StringWriter writer = new StringWriter();
        reference.writeTo(new StreamResult(writer));
        return writer.toString();
    }

    static {
        factory.setNamespaceAware(true);
    }
}

