/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl;

import org.gcube.io.jsonwebtoken.Header;
import org.gcube.io.jsonwebtoken.Jwt;
import org.gcube.io.jsonwebtoken.JwtVisitor;
import org.gcube.io.jsonwebtoken.io.Encoders;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Objects;

public class DefaultJwt<H extends Header, P>
implements Jwt<H, P> {
    private final H header;
    private final P payload;

    public DefaultJwt(H header, P payload) {
        this.header = (Header)Assert.notNull(header, "header cannot be null.");
        this.payload = Assert.notNull(payload, "payload cannot be null.");
    }

    @Override
    public H getHeader() {
        return this.header;
    }

    @Override
    public P getBody() {
        return this.getPayload();
    }

    @Override
    public P getPayload() {
        return this.payload;
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("header=").append(this.header).append(",payload=");
        if (this.payload instanceof byte[]) {
            String encoded = Encoders.BASE64URL.encode((byte[])this.payload);
            sb.append(encoded);
        } else {
            sb.append(this.payload);
        }
        return sb;
    }

    public final String toString() {
        return this.toStringBuilder().toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Jwt) {
            Jwt jwt = (Jwt)obj;
            return Objects.nullSafeEquals(this.header, jwt.getHeader()) && Objects.nullSafeEquals(this.payload, jwt.getPayload());
        }
        return false;
    }

    public int hashCode() {
        return Objects.nullSafeHashCode(this.header, this.payload);
    }

    @Override
    public <T> T accept(JwtVisitor<T> v) {
        return v.visit(this);
    }
}

