/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl;

import org.gcube.io.jsonwebtoken.Header;
import org.gcube.io.jsonwebtoken.Identifiable;
import org.gcube.io.jsonwebtoken.JweHeader;
import org.gcube.io.jsonwebtoken.JwsHeader;
import org.gcube.io.jsonwebtoken.Locator;
import org.gcube.io.jsonwebtoken.MalformedJwtException;
import org.gcube.io.jsonwebtoken.UnsupportedJwtException;
import org.gcube.io.jsonwebtoken.impl.lang.Function;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Registry;
import org.gcube.io.jsonwebtoken.lang.Strings;

public class IdLocator<H extends Header, R extends Identifiable>
implements Locator<R>,
Function<H, R> {
    private final Parameter<String> param;
    private final String requiredMsg;
    private final boolean valueRequired;
    private final Registry<String, R> registry;

    public IdLocator(Parameter<String> param, Registry<String, R> registry, String requiredExceptionMessage) {
        this.param = Assert.notNull(param, "Header param cannot be null.");
        this.requiredMsg = Strings.clean(requiredExceptionMessage);
        this.valueRequired = Strings.hasText(this.requiredMsg);
        Assert.notEmpty(registry, "Registry cannot be null or empty.");
        this.registry = registry;
    }

    private static String type(Header header) {
        if (header instanceof JweHeader) {
            return "JWE";
        }
        if (header instanceof JwsHeader) {
            return "JWS";
        }
        return "JWT";
    }

    @Override
    public R locate(Header header) {
        String id;
        Assert.notNull(header, "Header argument cannot be null.");
        Object val = header.get(this.param.getId());
        String string = id = val != null ? val.toString() : null;
        if (!Strings.hasText(id)) {
            if (this.valueRequired) {
                throw new MalformedJwtException(this.requiredMsg);
            }
            return null;
        }
        try {
            return (R)((Identifiable)this.registry.forKey(id));
        }
        catch (Exception e) {
            String msg = "Unrecognized " + IdLocator.type(header) + " " + this.param + " header value: " + id;
            throw new UnsupportedJwtException(msg, e);
        }
    }

    @Override
    public R apply(H header) {
        return (R)this.locate((Header)header);
    }
}

