/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Key;
import org.gcube.io.jsonwebtoken.impl.security.FamilyJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.JwkContext;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.security.Jwk;

class AsymmetricJwkFactory
implements FamilyJwkFactory<Key, Jwk<Key>> {
    private final String id;
    private final FamilyJwkFactory<Key, Jwk<Key>> publicFactory;
    private final FamilyJwkFactory<Key, Jwk<Key>> privateFactory;

    AsymmetricJwkFactory(FamilyJwkFactory publicFactory, FamilyJwkFactory privateFactory) {
        this.publicFactory = Assert.notNull(publicFactory, "publicFactory cannot be null.");
        this.privateFactory = Assert.notNull(privateFactory, "privateFactory cannot be null.");
        this.id = Assert.notNull(publicFactory.getId(), "publicFactory id cannot be null or empty.");
        Assert.isTrue(this.id.equals(privateFactory.getId()), "privateFactory id must equal publicFactory id");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean supports(JwkContext<?> ctx) {
        return ctx != null && (this.id.equals(ctx.getType()) || this.privateFactory.supports(ctx) || this.publicFactory.supports(ctx));
    }

    @Override
    public boolean supports(Key key) {
        return key != null && (this.privateFactory.supports(key) || this.publicFactory.supports(key));
    }

    @Override
    public JwkContext<Key> newContext(JwkContext<?> src, Key key) {
        return this.privateFactory.supports(key) || this.privateFactory.supports(src) ? this.privateFactory.newContext(src, key) : this.publicFactory.newContext(src, key);
    }

    @Override
    public Jwk<Key> createJwk(JwkContext<Key> ctx) {
        if (this.privateFactory.supports(ctx)) {
            return this.privateFactory.createJwk(ctx);
        }
        return this.publicFactory.createJwk(ctx);
    }
}

