/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.wps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.IOUtils;
import org.gcube.common.authorization.library.AuthorizedTasks;
import org.gcube.data.analysis.wps.ExecuteRequest;
import org.gcube.data.analysis.wps.ExecuteResponse;
import org.gcube.data.analysis.wps.GetCapabilitiesBuilder;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.EnvironmentVariableManager;
import org.gcube.smartgears.utils.InnerMethodName;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.WebProcessingService;
import org.n52.wps.server.handler.RequestExecutor;
import org.n52.wps.server.request.CapabilitiesRequest;
import org.n52.wps.server.request.DescribeProcessRequest;
import org.n52.wps.server.request.Request;
import org.n52.wps.server.request.RetrieveResultRequest;
import org.n52.wps.server.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RequestHandler {
    public static final String VERSION_ATTRIBUTE_NAME = "version";
    protected static RequestExecutor pool = new RequestExecutor();
    protected OutputStream os;
    private static Logger LOGGER = LoggerFactory.getLogger(RequestHandler.class);
    protected String responseMimeType;
    protected Request req;
    private EnvironmentVariableManager env;
    private Map<String, String[]> params;

    protected RequestHandler() {
    }

    public RequestHandler(Map<String, String[]> params, OutputStream os, EnvironmentVariableManager env) throws ExceptionReport {
        CapabilitiesRequest req;
        String requestType;
        this.os = os;
        this.params = params;
        this.env = env;
        CaseInsensitiveMap ciMap = new CaseInsensitiveMap(params);
        String serviceType = Request.getMapValue((String)"service", (CaseInsensitiveMap)ciMap, (boolean)true);
        if (!serviceType.equalsIgnoreCase("WPS")) {
            throw new ExceptionReport("Parameter <service> is not correct, expected: WPS, got: " + serviceType, "InvalidParameterValue", "service");
        }
        String language = Request.getMapValue((String)"language", (CaseInsensitiveMap)ciMap, (boolean)false);
        if (language != null) {
            Request.checkLanguageSupported((String)language);
        }
        if ((requestType = Request.getMapValue((String)"request", (CaseInsensitiveMap)ciMap, (boolean)true)).equalsIgnoreCase("GetCapabilities")) {
            req = new CapabilitiesRequest(ciMap);
            InnerMethodName.instance.set("GetCapabilities");
        } else if (requestType.equalsIgnoreCase("DescribeProcess")) {
            req = new DescribeProcessRequest(ciMap);
            InnerMethodName.instance.set("DescribeProcess");
        } else if (requestType.equalsIgnoreCase("Execute")) {
            req = new ExecuteRequest(ciMap, env);
            this.setResponseMimeType((ExecuteRequest)req);
            InnerMethodName.instance.set("Execute");
        } else if (requestType.equalsIgnoreCase("RetrieveResult")) {
            req = new RetrieveResultRequest(ciMap);
            InnerMethodName.instance.set("RetrieveResult");
        } else {
            throw new ExceptionReport("The requested Operation is not supported or not applicable to the specification: " + requestType, "OperationNotSupported", requestType);
        }
        this.req = req;
    }

    public RequestHandler(InputStream is, OutputStream os) throws ExceptionReport {
        String nodeURI;
        String localName;
        String nodeName;
        Document doc;
        String version = null;
        this.os = os;
        boolean isCapabilitiesNode = false;
        try {
            LOGGER.trace("Parsing Document...");
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setNamespaceAware(true);
            doc = fac.newDocumentBuilder().parse(is);
            LOGGER.trace("Document Parsing OK");
            Node child = doc.getFirstChild();
            while (child.getNodeName().compareTo("#comment") == 0) {
                child = child.getNextSibling();
            }
            LOGGER.trace("Skipped comments OK");
            nodeName = child.getNodeName();
            localName = child.getLocalName();
            nodeURI = child.getNamespaceURI();
            Node versionNode = child.getAttributes().getNamedItem(VERSION_ATTRIBUTE_NAME);
            LOGGER.trace("Version OK");
            Node serviceNode = child.getAttributes().getNamedItem("service");
            if (serviceNode == null) {
                throw new ExceptionReport("Parameter <service> not specified.", "MissingParameterValue", "service");
            }
            if (!serviceNode.getNodeValue().equalsIgnoreCase("WPS")) {
                throw new ExceptionReport("Parameter <service> not specified.", "InvalidParameterValue", "service");
            }
            LOGGER.trace("Service Node OK");
            isCapabilitiesNode = nodeName.toLowerCase().contains("capabilities");
            if (versionNode == null && !isCapabilitiesNode) {
                throw new ExceptionReport("Parameter <version> not specified.", "MissingParameterValue", VERSION_ATTRIBUTE_NAME);
            }
            if (!isCapabilitiesNode) {
                version = child.getAttributes().getNamedItem(VERSION_ATTRIBUTE_NAME).getNodeValue();
            }
            LOGGER.trace("Capabilities Node OK");
            Node languageNode = child.getAttributes().getNamedItem("language");
            if (languageNode != null) {
                String language = languageNode.getNodeValue();
                Request.checkLanguageSupported((String)language);
            }
            LOGGER.trace("Language Node OK " + languageNode);
        }
        catch (SAXException e) {
            throw new ExceptionReport("There went something wrong with parsing the POST data: " + e.getMessage(), "NoApplicableCode", (Throwable)e);
        }
        catch (IOException e) {
            throw new ExceptionReport("There went something wrong with the network connection.", "NoApplicableCode", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionReport("There is a internal parser configuration error", "NoApplicableCode", (Throwable)e);
        }
        if (!isCapabilitiesNode && version == null) {
            LOGGER.error("EXCEPTION: Parameter <version> not specified.MissingParameterValue version");
            throw new ExceptionReport("Parameter <version> not specified.", "MissingParameterValue", VERSION_ATTRIBUTE_NAME);
        }
        if (!isCapabilitiesNode && !version.equals("1.0.0")) {
            LOGGER.error("EXCEPTION: Version not supported.InvalidParameterValueversion");
            throw new ExceptionReport("Version not supported.", "InvalidParameterValue", VERSION_ATTRIBUTE_NAME);
        }
        if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE) && localName.equals("Execute")) {
            LOGGER.debug("Detected Request to Execute!");
            this.req = new ExecuteRequest(doc, this.env);
            this.setResponseMimeType((ExecuteRequest)this.req);
            InnerMethodName.instance.set("Execute");
            LOGGER.debug("Request to Execute Configured!");
        } else if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE) && localName.equals("GetCapabilities")) {
            LOGGER.debug("Detected GetCapabilities!");
            this.req = new CapabilitiesRequest(doc);
            InnerMethodName.instance.set("GetCapabilities");
            this.responseMimeType = "text/xml";
        } else if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE) && localName.equals("DescribeProcess")) {
            LOGGER.debug("Detected DescribeProcess!");
            this.req = new DescribeProcessRequest(doc);
            InnerMethodName.instance.set("DescribeProcess");
            this.responseMimeType = "text/xml";
        } else {
            if (!localName.equals("Execute")) {
                LOGGER.error("EXCEPTION Detected NON-supported Request The requested Operation not supported or not applicable to the specification: " + nodeName + "OperationNotSupported" + localName);
                throw new ExceptionReport("The requested Operation not supported or not applicable to the specification: " + nodeName, "OperationNotSupported", localName);
            }
            if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE)) {
                LOGGER.error("specified namespace is not supported: " + nodeURI + "InvalidParameterValue");
                throw new ExceptionReport("specified namespace is not supported: " + nodeURI, "InvalidParameterValue");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle() throws ExceptionReport {
        Response resp = null;
        if (this.req == null) {
            throw new ExceptionReport("Internal Error", "");
        }
        if (this.req instanceof ExecuteRequest) {
            LOGGER.debug("Request for execution");
            ExecuteRequest execReq = (ExecuteRequest)this.req;
            LOGGER.debug("Accepted request for execution");
            execReq.updateStatusAccepted();
            Callable execCallable = AuthorizedTasks.bind((Callable)execReq);
            ExceptionReport exceptionReport = null;
            try {
                block20: {
                    if (execReq.isStoreResponse()) {
                        LOGGER.debug("Execution with output storing");
                        resp = new ExecuteResponse(execReq);
                        InputStream is = resp.getAsStream();
                        IOUtils.copy((InputStream)is, (OutputStream)this.os);
                        is.close();
                        pool.submit(execCallable);
                        return;
                    }
                    try {
                        LOGGER.debug("Execution without storing output");
                        try {
                            resp = (Response)pool.submit(execCallable).get();
                        }
                        catch (ExecutionException ee) {
                            LOGGER.warn("exception while handling ExecuteRequest.", (Throwable)ee);
                            exceptionReport = ee.getCause() instanceof ExceptionReport ? (ExceptionReport)ee.getCause() : new ExceptionReport("An error occurred in the computation: " + ee.getMessage(), "NoApplicableCode");
                        }
                        catch (InterruptedException ie) {
                            LOGGER.warn("interrupted while handling ExecuteRequest.", (Throwable)ie);
                            exceptionReport = new ExceptionReport("The computation in the process was interrupted.", "NoApplicableCode");
                        }
                        if (exceptionReport == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (exceptionReport != null) {
                            LOGGER.warn("ExceptionReport not null", exceptionReport);
                            throw exceptionReport;
                        }
                        if (resp == null) {
                            LOGGER.warn("null response handling ExecuteRequest.");
                            throw new ExceptionReport("Problem with handling threads in RequestHandler", "NoApplicableCode");
                        }
                        if (execReq.isStoreResponse()) throw throwable;
                        InputStream is = resp.getAsStream();
                        IOUtils.copy((InputStream)is, (OutputStream)this.os);
                        is.close();
                        LOGGER.info("Served ExecuteRequest.");
                        throw throwable;
                    }
                    LOGGER.warn("ExceptionReport not null", (Throwable)exceptionReport);
                    throw exceptionReport;
                }
                if (resp == null) {
                    LOGGER.warn("null response handling ExecuteRequest.");
                    throw new ExceptionReport("Problem with handling threads in RequestHandler", "NoApplicableCode");
                }
                if (execReq.isStoreResponse()) return;
                InputStream is = resp.getAsStream();
                IOUtils.copy((InputStream)is, (OutputStream)this.os);
                is.close();
                LOGGER.info("Served ExecuteRequest.");
                return;
            }
            catch (RejectedExecutionException ree) {
                LOGGER.warn("exception handling ExecuteRequest.", (Throwable)ree);
                throw new ExceptionReport("The requested process was rejected. Maybe the server is flooded with requests.", "ServerBusy");
            }
            catch (Exception e) {
                LOGGER.error("exception handling ExecuteRequest.", (Throwable)e);
                if (!(e instanceof ExceptionReport)) throw new ExceptionReport("Could not read from response stream.", "NoApplicableCode");
                throw (ExceptionReport)((Object)e);
            }
        }
        resp = this.req.call();
        try {
            InputStream is = null;
            if (this.req instanceof CapabilitiesRequest) {
                GetCapabilitiesBuilder builder = new GetCapabilitiesBuilder();
                String getCapabilitiesStringFromInfra = "";
                try {
                    getCapabilitiesStringFromInfra = builder.buildGetCapabilities(this.params);
                }
                catch (Exception e) {
                    throw new ExceptionReport("Error in building GetCapabilities", "getcapabilities", (Throwable)e);
                }
                is = IOUtils.toInputStream((String)getCapabilitiesStringFromInfra, (String)"UTF-8");
            } else {
                is = resp.getAsStream();
            }
            IOUtils.copy((InputStream)is, (OutputStream)this.os);
            is.close();
            return;
        }
        catch (IOException e) {
            throw new ExceptionReport("Could not read from response stream.", "NoApplicableCode");
        }
    }

    protected void setResponseMimeType(ExecuteRequest req) {
        this.responseMimeType = req.isRawData() ? req.getExecuteResponseBuilder().getMimeType() : "text/xml";
    }

    public String getResponseMimeType() {
        if (this.responseMimeType == null) {
            return "text/xml";
        }
        return this.responseMimeType.toLowerCase();
    }
}

