/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.wps;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlbeans.XmlException;
import org.gcube.data.analysis.wps.RequestHandler;
import org.gcube.data.analysis.wps.repository.AlgorithmUpdater;
import org.gcube.data.analysis.wps.repository.GcubeAlgorithmRepository;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.EnvironmentVariableManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.n52.wps.GeneratorDocument;
import org.n52.wps.ParserDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.io.GeneratorFactory;
import org.n52.wps.io.ParserFactory;
import org.n52.wps.server.CapabilitiesConfiguration;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.database.DatabaseFactory;
import org.n52.wps.util.XMLBeansHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebProcessingService
extends HttpServlet {
    private static final long serialVersionUID = 8943233273641771839L;
    public static String PROPERTY_NAME_WEBAPP_PATH = "webappPath";
    private String configPath;
    public static String WEBAPP_PATH = null;
    public static String SERVLET_PATH = "WebProcessingService";
    public static String WPS_NAMESPACE = "http://www.opengis.net/wps/1.0.0";
    public static String DEFAULT_LANGUAGE = "en-US";
    protected static Logger LOGGER = LoggerFactory.getLogger(WebProcessingService.class);
    private static final String DIRECTORY_PARAM = "algorithmDirectory";
    private static final String MAX_COMPUTATION_PARAM = "maxComputation";
    private static final String SAVEONSTORAGE_PARAM = "saveOnStorage";
    private static final String SIMULATION_MODE_PARAM = "simulationMode";
    private static final String USER_WIRTE_EXCLUDED_PARAM = "excludeWritesOnSH";
    private static final String CONFIG_PATH = "configPath";
    private ApplicationContext context = ContextProvider.get();
    private EnvironmentVariableManager env;
    public static final int MAXIMUM_REQUEST_SIZE = 0x8000000;
    public static final String SPECIAL_XML_POST_VARIABLE = "request";
    private static final String XML_CONTENT_TYPE = "text/xml";

    public void init() throws ServletException {
        LOGGER.info("initialising WPS");
        String dir = this.context.application().getInitParameter("algorithmDirectory");
        GcubeAlgorithmRepository.setUpdater((AlgorithmUpdater)new AlgorithmUpdater(dir));
        int maxComp = Integer.parseInt(this.context.application().getInitParameter("maxComputation"));
        boolean saveOnStorage = Boolean.parseBoolean(this.context.application().getInitParameter("saveOnStorage"));
        boolean simulationMode = Boolean.parseBoolean(this.context.application().getInitParameter("simulationMode"));
        this.configPath = this.context.application().getInitParameter("configPath");
        String userWriteExcludedValue = this.context.application().getInitParameter("excludeWritesOnSH");
        List<Object> excludedUserForWrite = null;
        if (userWriteExcludedValue.isEmpty() || userWriteExcludedValue == null) {
            excludedUserForWrite = Collections.emptyList();
            LOGGER.debug("none is excluded in write");
        } else if (!userWriteExcludedValue.equals("*")) {
            excludedUserForWrite = Arrays.asList(userWriteExcludedValue.split(","));
            excludedUserForWrite.stream().forEach(i -> i.trim());
            LOGGER.debug("users excluded in write are {}", excludedUserForWrite);
        } else {
            LOGGER.debug("all users excluded in write");
        }
        this.env = new EnvironmentVariableManager(maxComp, saveOnStorage, simulationMode, excludedUserForWrite);
        LOGGER.info("WPS initialised");
    }

    private static OutputStream getConfiguredOutputStream(HttpServletRequest hsRequest, HttpServletResponse hsResponse) throws IOException {
        hsResponse.setHeader("Expires", "0");
        if (hsRequest.getProtocol().equals("HTTP/1.1")) {
            hsResponse.setHeader("Cache-Control", "no-cache");
        } else if (hsRequest.getProtocol().equals("HTTP/1.0")) {
            hsResponse.setHeader("Pragma", "no-cache");
        }
        if (hsRequest.getHeader("Accept-Encoding") != null && hsRequest.getHeader("Accept-Encoding").indexOf("gzip") >= 0) {
            hsResponse.setHeader("Content-Encoding", "gzip");
            LOGGER.info("gzip-Compression for output enabled");
            return new GZIPOutputStream((OutputStream)hsResponse.getOutputStream());
        }
        LOGGER.info("gzip-Compression for output disabled");
        return hsResponse.getOutputStream();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        System.setProperty("org.geotools.referencing.forceXY", "true");
        try {
            if (WPSConfig.getInstance((ServletConfig)config) == null) {
                LOGGER.error("Initialization failed! Please look at the properties file!");
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Initialization failed! Please look at the properties file!", (Throwable)e);
            return;
        }
        LOGGER.info("Initialization of wps properties successful!");
        ParserDocument.Parser[] parsers = WPSConfig.getInstance().getActiveRegisteredParser();
        ParserFactory.initialize((ParserDocument.Parser[])parsers);
        GeneratorDocument.Generator[] generators = WPSConfig.getInstance().getActiveRegisteredGenerator();
        GeneratorFactory.initialize((GeneratorDocument.Generator[])generators);
        LOGGER.info("Algorithms initialized");
        String customWebappPath = WPSConfig.getInstance().getWPSConfig().getServer().getWebappPath();
        if (customWebappPath != null) {
            WEBAPP_PATH = customWebappPath;
        } else {
            WEBAPP_PATH = "wps";
            LOGGER.warn("No custom webapp path found, use default wps");
        }
        LOGGER.info("webappPath is set to: " + customWebappPath);
        try {
            CapabilitiesConfiguration.getInstance((String)(this.configPath + File.separator + "config" + File.separator + "wpsCapabilitiesSkeleton.xml"));
        }
        catch (IOException e) {
            LOGGER.error("error while initializing capabilitiesConfiguration", (Throwable)e);
        }
        catch (XmlException e) {
            LOGGER.error("error while initializing capabilitiesConfiguration", (Throwable)e);
        }
        DatabaseFactory.getDatabase();
        LOGGER.info("WPS up and running!");
        WPSConfig.getInstance().addPropertyChangeListener("WPSCapabilitiesUpdate", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        WPSConfig.getInstance().addPropertyChangeListener("WPSConfigUpdate", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void setServerParameters() {
        String webapp = this.context.application().getContextPath().replace("//", "");
        WPSConfig.getInstance().getWPSConfig().getServer().setWebappPath(webapp);
        String protocol = WPSConfig.getInstance().getWPSConfig().getServer().getProtocol();
        String host = WPSConfig.getInstance().getWPSConfig().getServer().getHostname();
        String port = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
        if (host == null || host.toLowerCase().equals("localhost")) {
            LOGGER.info("resolving hostname and port from container.xml");
            host = this.context.container().configuration().hostname();
            port = Integer.toString(this.context.container().configuration().port());
            WPSConfig.getInstance().getWPSConfig().getServer().setHostname(host);
            WPSConfig.getInstance().getWPSConfig().getServer().setHostport(port);
        }
        LOGGER.debug("Setting server parameters: Host: {}, Port: {} , Webapp: {} ", new Object[]{host, port, webapp});
        String webPath = String.format("%s://%s:%d/%s/WebProcessingService", protocol, host, port, webapp);
        if (CapabilitiesConfiguration.ENDPOINT_URL.contains("localhost")) {
            CapabilitiesConfiguration.ENDPOINT_URL = webPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.setServerParameters();
            ServletOutputStream out = res.getOutputStream();
            RequestHandler handler = new RequestHandler(req.getParameterMap(), (OutputStream)out, this.env);
            String mimeType = handler.getResponseMimeType();
            res.setContentType(mimeType);
            handler.handle();
            res.setStatus(200);
        }
        catch (ExceptionReport e) {
            LOGGER.warn("Error handing request, handling exception", (Throwable)e);
            WebProcessingService.handleException((ExceptionReport)e, (HttpServletResponse)res);
        }
        catch (RuntimeException e) {
            LOGGER.error("Error handing request", (Throwable)e);
            ExceptionReport er = new ExceptionReport("Error handing request: " + e.getMessage(), "NoApplicableCode", (Throwable)e);
            WebProcessingService.handleException((ExceptionReport)er, (HttpServletResponse)res);
        }
        finally {
            if (res != null) {
                res.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.setServerParameters();
        BufferedReader reader = null;
        LOGGER.debug("Incoming Post Request");
        try {
            int requestSize;
            int read;
            String contentType = req.getContentType();
            String characterEncoding = req.getCharacterEncoding();
            if (characterEncoding == null || characterEncoding.length() == 0) {
                characterEncoding = "UTF-8";
            }
            LOGGER.debug("Set Encoding to {}", (Object)characterEncoding);
            int contentLength = req.getContentLength();
            if (contentLength > 0x8000000) {
                LOGGER.warn("POST request rejected, request size of " + contentLength + " too large.");
                ExceptionReport er = new ExceptionReport("Request body too large, limited to 134217728 bytes", "NoApplicableCode");
                WebProcessingService.handleException((ExceptionReport)er, (HttpServletResponse)res);
            }
            LOGGER.debug("Received POST: Content-Type = {}, Character-Encoding = {} , Content-Length = {} ", new Object[]{contentType, characterEncoding, contentLength});
            StringWriter writer = contentLength > 0 ? new StringWriter(contentLength) : new StringWriter();
            reader = req.getReader();
            char[] buffer = new char[8192];
            for (requestSize = 0; (read = reader.read(buffer)) != -1 && requestSize < 0x8000000; requestSize += read) {
                writer.write(buffer, 0, read);
            }
            LOGGER.debug("POST request contained  {} characters", (Object)requestSize);
            if (requestSize >= 0x8000000 && reader.read() > -1) {
                LOGGER.warn("POST request rejected, request size of {} too large.", (Object)requestSize);
                ExceptionReport er = new ExceptionReport("Request body too large, limited to 134217728 bytes", "NoApplicableCode");
                WebProcessingService.handleException((ExceptionReport)er, (HttpServletResponse)res);
            }
            String documentString = writer.toString();
            if (contentType.startsWith("application/x-www-form-urlencoded")) {
                if (documentString.startsWith("request=")) {
                    documentString = documentString.substring("request".length() + 1);
                    LOGGER.debug("POST request form variable removed");
                }
                documentString = URLDecoder.decode(documentString, characterEncoding);
                LOGGER.debug("Decoded of POST:\n" + documentString + "\n");
            } else {
                LOGGER.info("This is a standard xml document");
            }
            RequestHandler handler = new RequestHandler((InputStream)new ByteArrayInputStream(documentString.getBytes("UTF-8")), (OutputStream)res.getOutputStream(), this.env);
            LOGGER.debug("POST Request Handler created");
            String mimeType = handler.getResponseMimeType();
            LOGGER.debug("Request mimeType: " + mimeType);
            res.setContentType(mimeType);
            LOGGER.debug("Handling document");
            handler.handle();
            LOGGER.debug("STATUS OK!");
            res.setStatus(200);
        }
        catch (ExceptionReport e) {
            LOGGER.warn("Error handing request, handling exception", (Throwable)e);
            WebProcessingService.handleException((ExceptionReport)e, (HttpServletResponse)res);
        }
        catch (Exception e) {
            LOGGER.error("Error handing request", (Throwable)e);
            ExceptionReport er = new ExceptionReport("Error handing request: " + e.getMessage(), "NoApplicableCode", (Throwable)e);
            WebProcessingService.handleException((ExceptionReport)er, (HttpServletResponse)res);
        }
        finally {
            if (res != null) {
                res.flushBuffer();
            }
            if (reader != null) {
                reader.close();
            }
            LOGGER.trace("Flushing request");
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (SERVLET_PATH == null) {
            req.getContextPath();
        }
        super.service(req, res);
    }

    private static void handleException(ExceptionReport exception, HttpServletResponse res) {
        res.setContentType("text/xml");
        try {
            LOGGER.debug(exception.toString());
            exception.getExceptionDocument().save((OutputStream)res.getOutputStream(), XMLBeansHelper.getXmlOptions());
            res.setStatus(exception.getHTTPStatusCode());
        }
        catch (IOException e) {
            LOGGER.warn("exception occured while writing ExceptionReport to stream");
            try {
                res.sendError(500, "error occured, while writing OWS Exception output");
            }
            catch (IOException ex) {
                LOGGER.error("error while writing error code to client!");
                res.setStatus(500);
            }
        }
    }

    public void destroy() {
        super.destroy();
        DatabaseFactory.getDatabase().shutdown();
    }
}

