/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gFeed.collectors.oai.model.ckan;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.data.publishing.gCatfeeder.collectors.DataTransformer;
import org.gcube.data.publishing.gFeed.collectors.oai.Constants;
import org.gcube.data.publishing.gFeed.collectors.oai.model.DCRecordMetadata;
import org.gcube.data.publishing.gFeed.collectors.oai.model.OAIMetadata;
import org.gcube.data.publishing.gFeed.collectors.oai.model.OAIRecord;
import org.gcube.data.publishing.gFeed.collectors.oai.model.ckan.CkanItem;
import org.gcube.data.publishing.gFeed.collectors.oai.model.ckan.GCatModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCatTransformer
implements DataTransformer<GCatModel, OAIRecord> {
    private static final Logger log = LoggerFactory.getLogger(GCatTransformer.class);

    public Set<GCatModel> transform(Collection<OAIRecord> collectedData) {
        boolean useProfile = true;
        HashSet<GCatModel> toReturn = new HashSet<GCatModel>();
        for (OAIRecord record : collectedData) {
            GCatModel toPublish = GCatTransformer.translate(record, useProfile);
            if (useProfile) {
                useProfile = false;
            }
            toReturn.add(toPublish);
        }
        return toReturn;
    }

    private static GCatModel translate(OAIRecord toTranslate, Boolean useProfile) {
        GCatModel toReturn = new GCatModel();
        CkanItem item = new CkanItem();
        String toSetName = toTranslate.getHeader().getIdentifier();
        toSetName = toSetName.replaceAll("[^a-z0-9_\\\\-]", "_");
        item.setName(toSetName);
        OAIMetadata meta = toTranslate.getMetadata().getMetadata();
        if (meta instanceof DCRecordMetadata) {
            String profileID = "Harvested Object";
            DCRecordMetadata dcMeta = (DCRecordMetadata)meta;
            item.setTitle(GCatTransformer.getFirstOrDefault(dcMeta.getTitle(), "n.a."));
            item.setNotes(GCatTransformer.getFirstOrDefault(dcMeta.getDescription(), null));
            item.setAuthor(GCatTransformer.getFirstOrDefault(dcMeta.getPublisher(), "n.a."));
            item.setMaintainer(GCatTransformer.getFirstOrDefault(dcMeta.getPublisher(), null));
            item.setVersion("n.a.");
            item.setPrivateFlag(false);
            item.setLicense_id("CC-BY-NC-SA-4.0");
            if (dcMeta.getSubject() != null && dcMeta.getSubject().isEmpty()) {
                for (String subject : dcMeta.getSubject()) {
                    item.getTags().add(new CkanItem.Tag(subject));
                }
            }
            item.getTags().add(new CkanItem.Tag("OAI"));
            item.getExtras().add(new CkanItem.CKanExtraField("system:type", profileID));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getContributor(), profileID + ":contributor"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getCoverage(), profileID + ":coverage"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getCreator(), profileID + ":creator"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getDate(), profileID + ":date"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getDescription(), profileID + ":description"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getFormat(), profileID + ":format"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getIdentifier(), profileID + ":identifier"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getLanguage(), profileID + ":language"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getPublisher(), profileID + ":publisher"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getRelation(), profileID + ":relation"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getRights(), profileID + ":rights"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getSource(), profileID + ":source"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getSubject(), profileID + ":subject"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getTitle(), profileID + ":title"));
            item.getExtras().addAll(GCatTransformer.fromList(dcMeta.getType(), profileID + ":type"));
            if (dcMeta.getIdentifier() != null) {
                ArrayList<GCatModel.CkanResource> list = new ArrayList<GCatModel.CkanResource>();
                for (String id : dcMeta.getIdentifier()) {
                    try {
                        URL url = new URL(id);
                        GCatModel.CkanResource res = new GCatModel.CkanResource("Record", url + "", url.getProtocol(), "Original record");
                        list.add(res);
                    }
                    catch (Throwable t) {
                        log.debug("Unable to set identifier " + id + "as resource ", t);
                    }
                }
                toReturn.setResources(list);
            }
        }
        toReturn.setItem(item);
        try {
            if (useProfile.booleanValue()) {
                toReturn.setProfile(Constants.xmlProfiles.get("HarvestedObject"));
            }
        }
        catch (Throwable t) {
            log.error("Unable to set profile ", t);
        }
        return toReturn;
    }

    private static Collection<CkanItem.CKanExtraField> fromList(List<String> values, String name) {
        ArrayList<CkanItem.CKanExtraField> toReturn = new ArrayList<CkanItem.CKanExtraField>();
        if (values != null) {
            for (String v : values) {
                toReturn.add(new CkanItem.CKanExtraField(name, v));
            }
        }
        return toReturn;
    }

    private static String getFirstOrDefault(List<String> values, String defaultValue) {
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return defaultValue;
    }
}

