package org.gcube.gcat.api.interfaces;

import java.util.Map;

import javax.xml.ws.WebServiceException;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public interface Item<C,D> extends CRUD<C,D> {
	
	public static final String ITEMS = "items";
	
	public int count() throws WebServiceException;
	
	public String list(Map<String,String> parameters) throws WebServiceException;
	
	public String list(int limit, int offset) throws WebServiceException;
	
	public String patch(String name, String json) throws WebServiceException;
	
	public D delete(String name, boolean purge) throws WebServiceException;
	
	public D purge(String name) throws WebServiceException;
}
