/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.gcube.common.gxhttp.reference.GXConnection;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.gcat.client.GCatClientDiscovery;

abstract class GCatClient {
    protected URL serviceURL;
    protected List<String> basePaths;
    protected GXHTTPStringRequest gxhttpStringRequest;

    public void enforceServiceURL(URL enforcedServiceURL) {
        this.serviceURL = enforcedServiceURL;
    }

    public GCatClient(URL enforcedServiceURL, String basePath, String ... basePaths) throws MalformedURLException {
        this.serviceURL = enforcedServiceURL;
        this.basePaths = new ArrayList<String>();
        this.basePaths.add(basePath);
        this.basePaths.addAll(Arrays.asList(basePaths));
    }

    public GCatClient(String basePath, String ... basePaths) throws MalformedURLException {
        this.serviceURL = GCatClientDiscovery.getServiceURL();
        this.basePaths = new ArrayList<String>();
        this.basePaths.add(basePath);
        this.basePaths.addAll(Arrays.asList(basePaths));
    }

    protected static StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result;
    }

    protected String parseHttpURLConnection(HttpURLConnection connection) throws WebApplicationException {
        try {
            int responseCode = connection.getResponseCode();
            if (connection.getRequestMethod().compareTo(GXConnection.HTTPMETHOD.HEAD.toString()) == 0) {
                if (responseCode == 204) {
                    String string = null;
                    return string;
                }
                if (responseCode == 404) {
                    throw new NotFoundException();
                }
                if (responseCode == 403) {
                    throw new ForbiddenException();
                }
            }
            if (responseCode >= 400) {
                InputStream inputStream = connection.getErrorStream();
                StringBuilder result = GCatClient.getStringBuilder(inputStream);
                String res = result.toString();
                throw new WebApplicationException(res, responseCode);
            }
            StringBuilder result = GCatClient.getStringBuilder(connection.getInputStream());
            String string = result.toString();
            return string;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            connection.disconnect();
        }
    }

    protected void initRequest() throws UnsupportedEncodingException {
        this.gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)this.serviceURL.toString());
        this.gxhttpStringRequest.from(GCatClient.class.getSimpleName());
        for (String p : this.basePaths) {
            this.gxhttpStringRequest.path(p);
        }
    }

    protected String list(Map<String, String> queryParams, String ... paths) throws WebApplicationException {
        try {
            this.initRequest();
            for (String p : paths) {
                this.gxhttpStringRequest.path(p);
            }
            this.gxhttpStringRequest.queryParams(queryParams);
            HttpURLConnection httpURLConnection = this.gxhttpStringRequest.get();
            return this.parseHttpURLConnection(httpURLConnection);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected String create(String body, String ... paths) {
        try {
            this.initRequest();
            for (String p : paths) {
                this.gxhttpStringRequest.path(p);
            }
            HttpURLConnection httpURLConnection = this.gxhttpStringRequest.post(body);
            return this.parseHttpURLConnection(httpURLConnection);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected String read(String ... paths) throws WebApplicationException {
        try {
            this.initRequest();
            for (String p : paths) {
                this.gxhttpStringRequest.path(p);
            }
            HttpURLConnection httpURLConnection = this.gxhttpStringRequest.get();
            return this.parseHttpURLConnection(httpURLConnection);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected String update(String body, String ... paths) throws WebApplicationException {
        try {
            this.initRequest();
            for (String p : paths) {
                this.gxhttpStringRequest.path(p);
            }
            HttpURLConnection httpURLConnection = this.gxhttpStringRequest.put(body);
            return this.parseHttpURLConnection(httpURLConnection);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected String patch(String body, String ... paths) throws WebApplicationException {
        try {
            this.initRequest();
            for (String p : paths) {
                this.gxhttpStringRequest.path(p);
            }
            this.gxhttpStringRequest.withBody(body);
            HttpURLConnection httpURLConnection = this.gxhttpStringRequest.patch();
            return this.parseHttpURLConnection(httpURLConnection);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected String delete(Boolean purge, String ... paths) throws WebApplicationException {
        try {
            this.initRequest();
            for (String p : paths) {
                this.gxhttpStringRequest.path(p);
            }
            if (purge != null) {
                HashMap<String, String> queryParams = new HashMap<String, String>();
                queryParams.put("purge", String.valueOf(purge));
                this.gxhttpStringRequest.queryParams(queryParams);
            }
            HttpURLConnection httpURLConnection = this.gxhttpStringRequest.delete();
            return this.parseHttpURLConnection(httpURLConnection);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

