/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.persistence.ckan;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogue;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogueFactory;
import org.gcube.gcat.persistence.ckan.CKANUtility;
import org.gcube.gcat.utils.ContextUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class CKAN {
    private static final Logger logger = LoggerFactory.getLogger(CKAN.class);
    protected static final String ID_KEY = "id";
    protected static final String NAME_KEY = "name";
    protected static final String ERROR_KEY = "error";
    protected static final String ERROR_TYPE_KEY = "__type";
    protected static final String MESSAGE_KEY = "message";
    protected static final String OWNER_ORG_KEY = "owner_org";
    protected static final String RESULT_KEY = "result";
    protected static final String SUCCESS_KEY = "success";
    public static final String LIMIT_KEY = "limit";
    public static final String OFFSET_KEY = "offset";
    protected static final String NOT_FOUND_ERROR = "Not Found Error";
    protected static final String AUTHORIZATION_ERROR = "Authorization Error";
    protected static final String VALIDATION_ERROR = "Validation Error";
    public static final String CKAN_API_PATH = "/api/3/action/";
    public static final String AUTH_CKAN_HEADER = "Authorization";
    protected String LIST;
    protected String CREATE;
    protected String READ;
    protected String UPDATE;
    protected String PATCH;
    protected String DELETE;
    protected String PURGE;
    protected final ObjectMapper mapper;
    protected final DataCatalogue dataCatalogue;
    protected String name;
    protected String apiKey;
    protected JsonNode result;

    public String getApiKey() {
        if (this.apiKey == null) {
            try {
                return CKANUtility.getApiKey();
            }
            catch (Exception e) {
                throw new InternalServerErrorException((Throwable)e);
            }
        }
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public JsonNode getJsonNodeResult() {
        return this.result;
    }

    protected CKAN() {
        try {
            this.mapper = new ObjectMapper();
            this.dataCatalogue = CKAN.getCatalogue();
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected JsonNode getAsJsonNode(String json) {
        try {
            return this.mapper.readTree(json);
        }
        catch (IOException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    public static DataCatalogue getCatalogue() throws Exception {
        String context = ContextUtility.getCurrentContext();
        logger.debug("Discovering ckan instance in context {}", (Object)context);
        return DataCatalogueFactory.getFactory().getUtilsPerScope(context);
    }

    protected JsonNode validateCKANResponse(String json) {
        JsonNode jsonNode = this.getAsJsonNode(json);
        if (jsonNode.get("success").asBoolean()) {
            return jsonNode.get("result");
        }
        try {
            JsonNode error = jsonNode.get("error");
            String errorType = error.get("__type").asText();
            if (errorType.compareTo("Validation Error") == 0) {
                throw new BadRequestException(this.getAsString(error));
            }
            String message = error.get("message").asText();
            if (errorType.compareTo("Not Found Error") == 0) {
                throw new NotFoundException(message);
            }
            if (errorType.compareTo("Authorization Error") == 0) {
                throw new NotAuthorizedException((Object)message, new Object[0]);
            }
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BadRequestException(json);
        }
        throw new BadRequestException(json);
    }

    protected String getAsString(JsonNode node) {
        try {
            String json = this.mapper.writeValueAsString((Object)node);
            return json;
        }
        catch (JsonProcessingException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected JsonNode checkName(JsonNode jsonNode) {
        try {
            String gotName = jsonNode.get("name").asText();
            if (this.name == null) {
                this.name = gotName;
            }
            if (gotName != null && gotName.compareTo(this.name) != 0) {
                String error = String.format("The name (%s) does not match with the '%s' contained in the provided content (%s).", this.name, "name", gotName);
                throw new BadRequestException(error);
            }
            return jsonNode;
        }
        catch (BadRequestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BadRequestException("Unable to obtain a correct 'name' from the provided content");
        }
    }

    protected JsonNode checkName(String json) {
        JsonNode jsonNode = this.getAsJsonNode(json);
        this.checkName(jsonNode);
        return jsonNode;
    }

    protected JsonNode createJsonNodeWithID(String id) {
        ObjectNode objectNode = this.mapper.createObjectNode();
        objectNode.put("id", id);
        return objectNode;
    }

    protected JsonNode createJsonNodeWithNameAsID() {
        return this.createJsonNodeWithID(this.name);
    }

    protected Map<String, String> getMapWithNameAsID() {
        return this.getMapWithID(this.name);
    }

    protected Map<String, String> getMapWithID(String id) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        return map;
    }

    protected StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result;
    }

    protected GXHTTPStringRequest getGXHTTPStringRequest(String path) throws UnsupportedEncodingException {
        String catalogueURL = this.dataCatalogue.getCatalogueUrl();
        GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)catalogueURL);
        gxhttpStringRequest.from("gCat");
        gxhttpStringRequest.header("Content-type", "application/json");
        gxhttpStringRequest.isExternalCall(true);
        gxhttpStringRequest.header("Authorization", this.getApiKey());
        gxhttpStringRequest.path(path);
        return gxhttpStringRequest;
    }

    protected String getResultAsString(HttpURLConnection httpURLConnection) throws IOException {
        int responseCode = httpURLConnection.getResponseCode();
        if (responseCode >= Response.Status.BAD_REQUEST.getStatusCode()) {
            Response.Status status = Response.Status.fromStatusCode((int)responseCode);
            throw new WebApplicationException(status);
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        String ret = this.getStringBuilder(inputStream).toString();
        logger.trace("Got Respose is {}", (Object)ret);
        this.result = this.validateCKANResponse(ret);
        if (this.result instanceof NullNode) {
            this.result = this.mapper.createObjectNode();
        }
        return this.getAsString(this.result);
    }

    protected String sendGetRequest(String path, Map<String, String> parameters) {
        try {
            GXHTTPStringRequest gxhttpStringRequest = this.getGXHTTPStringRequest(path);
            gxhttpStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxhttpStringRequest.get();
            return this.getResultAsString(httpURLConnection);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected String sendPostRequest(String path, String body) {
        try {
            GXHTTPStringRequest gxhttpStringRequest = this.getGXHTTPStringRequest(path);
            HttpURLConnection httpURLConnection = gxhttpStringRequest.post(body);
            return this.getResultAsString(httpURLConnection);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected String sendPostRequest(String path, JsonNode jsonNode) {
        return this.sendPostRequest(path, this.getAsString(jsonNode));
    }

    public String list(int limit, int offset) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (limit > 0) {
            parameters.put("limit", String.valueOf(limit));
        }
        if (offset >= 0) {
            parameters.put("offset", String.valueOf(offset));
        }
        return this.sendGetRequest(this.LIST, parameters);
    }

    public String create(String json) {
        return this.sendPostRequest(this.CREATE, json);
    }

    public String read() {
        return this.sendGetRequest(this.READ, this.getMapWithNameAsID());
    }

    public String update(String json) {
        this.checkName(json);
        return this.sendPostRequest(this.UPDATE, json);
    }

    public String patch(String json) {
        JsonNode jsonNode = this.checkName(json);
        ObjectNode objectNode = (ObjectNode)jsonNode;
        objectNode.put("id", this.name);
        objectNode.remove("name");
        return this.sendPostRequest(this.PATCH, (JsonNode)objectNode);
    }

    protected void delete() {
        this.sendPostRequest(this.DELETE, this.createJsonNodeWithNameAsID());
    }

    public void delete(boolean purge) {
        if (purge) {
            this.purge();
        } else {
            this.delete();
        }
    }

    protected void purge() {
        this.sendPostRequest(this.PURGE, this.createJsonNodeWithNameAsID());
    }
}

