package org.gcube.gcat.rest;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Response.ResponseBuilder;

import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseREST {
	
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Context
	private UriInfo uriInfo;

	public static final String GROUPS = "groups";
	public static final String ITEMS = "items";
	public static final String LICENSES = "licenses";
	public static final String NAMESPACES = "namespaces";
	public static final String ORGANIZATIONS = "organizations";
	public static final String PROFILES = "profiles";
	public static final String RESOURCES = "resources";
	public static final String USERS = "users";
	
	public static final String PURGE_QUERY_PARAMETER = "purge";
	
	public static final String APPLICATION_JSON_CHARSET_UTF_8 = MediaType.APPLICATION_JSON + ";charset=UTF-8";
	
	protected static final String LOCATION_HEADER = "Location";
	
	public static final String LIMIT_PARAMETER = "limit";
	public static final String OFFSET_PARAMETER = "offset";
	
	protected void setCalledMethod(String method) {
		CalledMethodProvider.instance.set(method);
		logger.info("{}", uriInfo.getAbsolutePath());
	}
	
	protected ResponseBuilder addLocation(ResponseBuilder responseBuilder, String id) {
		return responseBuilder.header(LOCATION_HEADER,
				String.format("%s/%s", uriInfo.getAbsolutePath().toString(), id)
		);
	}
	
}
