/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.HttpURLConnection;
import javax.ws.rs.WebApplicationException;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogue;
import org.gcube.datacatalogue.ckanutillibrary.server.utils.url.EntityContext;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.utils.ContextUtility;

public class URIResolver {
    private static final String CATALOGUE_CONTEXT = "gcube_scope";
    private static final String ENTITY_TYPE = "entity_context";
    private static final String ENTITY_NAME = "entity_name";
    private static final String CATALOGUE_PLAIN_URL = "clear_url";
    protected ObjectMapper objectMapper = new ObjectMapper();

    public String getCatalogueItemURL(String name) {
        try {
            DataCatalogue dataCatalogue = CKAN.getCatalogue();
            String uriResolverURL = dataCatalogue.getUriResolverUrl();
            ObjectNode requestContent = this.objectMapper.createObjectNode();
            requestContent.put(CATALOGUE_CONTEXT, ContextUtility.getCurrentContext());
            requestContent.put(ENTITY_TYPE, EntityContext.PRODUCT.toString());
            requestContent.put(ENTITY_NAME, name);
            requestContent.put(CATALOGUE_PLAIN_URL, true);
            GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)uriResolverURL);
            gxhttpStringRequest.header("User-Agent", "gCat");
            HttpURLConnection httpURLConnection = gxhttpStringRequest.post(this.objectMapper.writeValueAsString((Object)requestContent));
            String url = httpURLConnection.getResponseMessage();
            return url;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

