/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.persistence.ckan;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.persistence.ckan.CKANGroup;
import org.gcube.gcat.utils.RandomString;

public class CKANUser
extends CKAN {
    public static final String USER_LIST = "/api/3/action/user_list";
    public static final String USER_CREATE = "/api/3/action/user_create";
    public static final String USER_SHOW = "/api/3/action/user_show";
    public static final String USER_UPDATE = "/api/3/action/user_update";
    public static final String USER_DELETE = "/api/3/action/user_delete";
    public static final String ADD_USER_TO_GROUP = "/api/3/action/member_create";
    public static final String NAME = "name";
    public static final String EMAIL = "email";
    public static final String PASSWORD = "password";

    public CKANUser() {
        this.LIST = USER_LIST;
        this.CREATE = USER_CREATE;
        this.READ = USER_SHOW;
        this.UPDATE = USER_UPDATE;
        this.PATCH = null;
        this.DELETE = USER_DELETE;
        this.PURGE = null;
    }

    public String create() {
        RandomString randomString = new RandomString(12);
        ObjectNode objectNode = this.mapper.createObjectNode();
        objectNode.put(NAME, this.name);
        objectNode.put(EMAIL, this.name + "@gcube.ckan.org");
        objectNode.put(PASSWORD, randomString.nextString());
        return this.create(this.getAsString((JsonNode)objectNode));
    }

    public void delete(boolean purge) {
        this.delete();
    }

    public void addToGroup(String groupName) throws WebApplicationException {
        try {
            ObjectNode objectNode = this.mapper.createObjectNode();
            objectNode.put("id", CKANGroup.getGroupName((String)groupName));
            objectNode.put("object", this.name);
            objectNode.put("object_type", "user");
            objectNode.put("capacity", "member");
            this.sendPostRequest(ADD_USER_TO_GROUP, this.getAsString((JsonNode)objectNode));
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

