/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.social;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.cache.Cache;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.datacatalogue.ckanutillibrary.server.DataCatalogue;
import org.gcube.gcat.oldutils.CachesManager;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.social.GcoreEndpointReaderSNL;
import org.gcube.gcat.utils.Constants;
import org.gcube.gcat.utils.ContextUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialService
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(SocialService.class);
    public static final String ITEM_URL = "Item URL";
    protected static final String SOCIAL_SERVICE_WRITE_APPLICATION_POST_PATH = "/2/posts/write-post-app";
    protected static final String SOCIAL_SERVICE_GET_USER_INFO_PATH = "2/users/get-profile";
    protected static final String NOTIFICATION_MESSAGE = "%s just published the item \"%s\"\nPlease find it at %s\n";
    protected static final String RESULT_KEY = "result";
    protected static final String FULLNAME_IN_PROFILE_KEY = "fullname";
    protected static final String SOCIAL_POST_TEXT_KEY = "text";
    protected static final String SOCIAL_POST_ENABLE_NOTIFICATION_KEY = "enable_notification";
    protected static final String SOCIAL_POST_RESPONSE_SUCCESS_KEY = "success";
    protected static final String SOCIAL_POST_RESPONSE_MESSAGE_KEY = "message";
    protected final GcoreEndpointReaderSNL gcoreEndpointReaderSNL = new GcoreEndpointReaderSNL();
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected String itemID;
    protected String itemURL;
    protected String itemTitle;
    protected List<String> tags;
    protected JsonNode gCubeUserProfile;

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public String getItemURL() {
        return this.itemURL;
    }

    public void setItemURL(String itemURL) {
        this.itemURL = itemURL;
    }

    public String getItemTitle() {
        return this.itemTitle;
    }

    public void setItemTitle(String itemTitle) {
        this.itemTitle = itemTitle;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setTags(ArrayNode tags) {
        this.tags = new ArrayList();
        if (tags != null && tags.size() > 0) {
            for (int i = 0; i < tags.size(); ++i) {
                JsonNode jsonNode = tags.get(i);
                String tagName = "";
                tagName = jsonNode.has("display_name") ? jsonNode.get("display_name").asText() : jsonNode.get("name").asText();
                this.tags.add(tagName);
            }
        }
    }

    public JsonNode getGCubeUserProfile() throws Exception {
        if (this.gCubeUserProfile == null) {
            String username = ContextUtility.getUsername();
            this.gCubeUserProfile = this.getGCubeUserProfile(username);
        }
        return this.gCubeUserProfile;
    }

    protected StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result;
    }

    protected String getResultAsString(HttpURLConnection httpURLConnection) throws IOException {
        int responseCode = httpURLConnection.getResponseCode();
        if (responseCode >= Response.Status.BAD_REQUEST.getStatusCode()) {
            Response.Status status = Response.Status.fromStatusCode((int)responseCode);
            InputStream inputStream = httpURLConnection.getErrorStream();
            StringBuilder result = this.getStringBuilder(inputStream);
            logger.trace(result.toString());
            throw new WebApplicationException(status);
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        String ret = this.getStringBuilder(inputStream).toString();
        logger.trace("Got Respose is {}", (Object)ret);
        return ret;
    }

    protected JsonNode getGCubeUserProfile(String username) throws Exception {
        Cache userCache = CachesManager.getUserCache();
        if (userCache.containsKey((Object)username)) {
            return (JsonNode)userCache.get((Object)username);
        }
        String socialServiceBasePath = this.gcoreEndpointReaderSNL.getServiceBasePath();
        GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)socialServiceBasePath);
        gxhttpStringRequest.header("User-Agent", "gCat");
        gxhttpStringRequest.header("Accept", "application/json");
        gxhttpStringRequest.path(SOCIAL_SERVICE_GET_USER_INFO_PATH);
        HttpURLConnection httpURLConnection = gxhttpStringRequest.get();
        String ret = this.getResultAsString(httpURLConnection);
        JsonNode jsonNode = this.objectMapper.readTree(ret);
        userCache.put((Object)username, (Object)jsonNode);
        return jsonNode;
    }

    public String getFullName() throws Exception {
        try {
            if (!ContextUtility.isApplication()) {
                JsonNode jsonNode = this.getGCubeUserProfile();
                JsonNode result = jsonNode.get(RESULT_KEY);
                return result.get(FULLNAME_IN_PROFILE_KEY).asText();
            }
        }
        catch (Exception e) {
            logger.warn("Unable to get the full name of the requesting user via Social Service. The username corresponsing to the requester token will be used.");
        }
        return ContextUtility.getUsername();
    }

    @Override
    public void run() {
        try {
            DataCatalogue dataCatalogue = CKAN.getCatalogue();
            if (!dataCatalogue.isSocialPostEnabled()) {
                logger.info("Social Post are disabled in the context {}", (Object)ContextUtility.getCurrentContext());
                return;
            }
            logger.info("Going to send Social Post about the Item {} available at {}", (Object)this.itemID, (Object)this.itemURL);
            boolean notifyUsers = dataCatalogue.isNotificationToUsersEnabled();
            this.sendSocialPost(notifyUsers);
        }
        catch (Exception e) {
            logger.error("Error while executing post creation actions", (Throwable)e);
        }
    }

    public void sendSocialPost(boolean notifyUsers) {
        try {
            String fullName = this.getFullName();
            String basePath = this.gcoreEndpointReaderSNL.getServiceBasePath();
            if (basePath == null) {
                logger.info("Unable to write a post because there is no social networking service available");
                return;
            }
            basePath = basePath.endsWith("/") ? basePath : basePath + "/";
            StringWriter messageWriter = new StringWriter();
            messageWriter.append(String.format(NOTIFICATION_MESSAGE, fullName, this.itemTitle, this.itemURL));
            for (String tag : this.tags) {
                tag = tag.trim();
                if ((tag = tag.replaceAll(" ", "_").replace("_+", "_")).endsWith("_")) {
                    tag = tag.substring(0, tag.length() - 1);
                }
                messageWriter.append("#");
                messageWriter.append(tag);
                messageWriter.append(" ");
            }
            String message = messageWriter.toString();
            logger.debug("The post that is going to be written is\n{}", (Object)message);
            ObjectNode objectNode = this.objectMapper.createObjectNode();
            objectNode.put(SOCIAL_POST_TEXT_KEY, message);
            objectNode.put(SOCIAL_POST_ENABLE_NOTIFICATION_KEY, notifyUsers);
            GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)basePath);
            gxhttpStringRequest.from("gCat");
            gxhttpStringRequest.header("Content-Type", "application/json");
            gxhttpStringRequest.setSecurityToken(Constants.getCatalogueApplicationToken());
            gxhttpStringRequest.path(SOCIAL_SERVICE_WRITE_APPLICATION_POST_PATH);
            HttpURLConnection httpURLConnection = gxhttpStringRequest.post(this.objectMapper.writeValueAsString((Object)objectNode));
            String ret = this.getResultAsString(httpURLConnection);
            JsonNode jsonNode = this.objectMapper.readTree(ret);
            if (jsonNode.get(SOCIAL_POST_RESPONSE_SUCCESS_KEY).asBoolean()) {
                logger.info("Post written : {}", (Object)message);
            } else {
                logger.info("Failed to write the post {}. Reason {}", (Object)message, (Object)jsonNode.get(SOCIAL_POST_RESPONSE_MESSAGE_KEY).asText());
            }
        }
        catch (Exception e) {
            logger.error("Unable to send Social Post", (Throwable)e);
        }
    }
}

