/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.persistence.ckan;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.gcat.persistence.ckan.CKAN;
import org.gcube.gcat.persistence.ckan.CKANGroup;
import org.gcube.gcat.persistence.ckan.CKANOrganization;
import org.gcube.gcat.persistence.ckan.CKANUser;
import org.gcube.gcat.persistence.ckan.CKANUtility;
import org.gcube.gcat.social.PortalUser;
import org.gcube.gcat.utils.ContextUtility;
import org.gcube.gcat.utils.RandomString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CKANUser
extends CKAN {
    private static final Logger logger = LoggerFactory.getLogger(CKANUser.class);
    public static final String USER_LIST = "/api/3/action/user_list";
    public static final String USER_CREATE = "/api/3/action/user_create";
    public static final String USER_SHOW = "/api/3/action/user_show";
    public static final String USER_UPDATE = "/api/3/action/user_update";
    public static final String USER_DELETE = "/api/3/action/user_delete";
    public static final String ADD_USER_TO_GROUP = "/api/3/action/member_create";
    public static final String NAME = "name";
    public static final String DISPLAY_NAME = "display_name";
    public static final String FULL_NAME = "fullname";
    public static final String ABOUT = "about";
    public static final String EMAIL = "email";
    public static final String PASSWORD = "password";
    private static final String API_KEY = "apikey";
    protected PortalUser portalUser;
    protected Role role;

    public CKANUser() {
        this.LIST = "/api/3/action/user_list";
        this.CREATE = "/api/3/action/user_create";
        this.READ = "/api/3/action/user_show";
        this.UPDATE = "/api/3/action/user_update";
        this.PATCH = null;
        this.DELETE = "/api/3/action/user_delete";
        this.PURGE = null;
    }

    public String create() {
        RandomString randomString = new RandomString(12);
        ObjectNode objectNode = this.mapper.createObjectNode();
        objectNode.put("name", this.name);
        objectNode.put("password", randomString.nextString());
        this.checkAndSetEMail(objectNode);
        this.checkAndSetFullName(objectNode);
        this.checkAndSetJobTitle(objectNode);
        return this.create(this.getAsString((JsonNode)objectNode));
    }

    public void delete(boolean purge) {
        this.delete();
    }

    private boolean checkAndSetJobTitle(ObjectNode objectNode) {
        String portalJobTitle = this.getPortalUser().getJobTitle();
        String ckanJobTitle = "";
        if (objectNode.has("about")) {
            ckanJobTitle = objectNode.get("about").asText();
        }
        if (portalJobTitle.compareTo(ckanJobTitle) != 0) {
            objectNode = (ObjectNode)this.result;
            objectNode.put("about", portalJobTitle);
            return true;
        }
        return false;
    }

    private boolean checkAndSetFullName(ObjectNode objectNode) {
        String portalFullname = this.getPortalUser().getFullName();
        String ckanFullname = "";
        if (objectNode.has("fullname")) {
            ckanFullname = objectNode.get("fullname").asText();
        }
        if (portalFullname.compareTo(ckanFullname) != 0) {
            objectNode = (ObjectNode)this.result;
            objectNode.put("fullname", portalFullname);
            objectNode.put("display_name", portalFullname);
            return true;
        }
        return false;
    }

    private boolean checkAndSetEMail(ObjectNode objectNode) {
        String portalEmail = this.getPortalUser().getEMail();
        String ckanEmail = "";
        if (objectNode.has("email")) {
            ckanEmail = objectNode.get("email").asText();
        }
        if (portalEmail.compareTo(ckanEmail) != 0) {
            objectNode = (ObjectNode)this.result;
            objectNode.put("email", portalEmail);
            return true;
        }
        return false;
    }

    protected boolean updateProfileIfNeeded() {
        ObjectNode objectNode = (ObjectNode)this.result;
        boolean toBeUpdated = false;
        toBeUpdated = this.checkAndSetEMail(objectNode) || toBeUpdated;
        toBeUpdated = this.checkAndSetFullName(objectNode) || toBeUpdated;
        boolean bl = toBeUpdated = this.checkAndSetJobTitle(objectNode) || toBeUpdated;
        if (toBeUpdated) {
            this.update(this.getAsString((JsonNode)objectNode));
        }
        return toBeUpdated;
    }

    protected void retrieve() {
        this.setApiKey(CKANUtility.getSysAdminAPI());
        try {
            if (this.name == null || this.name.compareTo("") == 0) {
                this.setName(CKANUser.getCKANUsername());
            }
            this.read();
            this.updateProfileIfNeeded();
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatusInfo() == Response.Status.NOT_FOUND) {
                this.create();
            }
            throw e;
        }
        try {
            this.addUserToOrganization();
        }
        catch (Exception e) {
            logger.warn("Add user to organization {} failed. This is acceptable in the case the request is at VO level and the corresponding orgnization does not esists and should not, as well as when the organization is going to be created", (Object)CKANOrganization.getCKANOrganizationName());
        }
    }

    protected void parseResult() {
        block2: {
            this.name = this.result.get("name").asText();
            try {
                this.apiKey = this.result.get("apikey").asText();
            }
            catch (Exception e) {
                if (this.name.compareTo(CKANUser.getCKANUsername()) != 0) break block2;
                throw e;
            }
        }
    }

    protected static String getCKANUsername(String username) {
        if (username == null) {
            return null;
        }
        return username.trim().replaceAll("\\.", "_");
    }

    public static String getCKANUsername() {
        return CKANUser.getCKANUsername((String)ContextUtility.getUsername());
    }

    public String read() {
        String ret = super.read();
        this.parseResult();
        return ret;
    }

    protected void addUserToOrganization(String organizationName, String ckanUsername, String role) {
        logger.trace("Going to add user {} to organization {} with role {}", new Object[]{ckanUsername, organizationName, role});
        CKANOrganization ckanOrganization = new CKANOrganization();
        ckanOrganization.setApiKey(CKANUtility.getSysAdminAPI());
        ckanOrganization.setName(organizationName);
        ckanOrganization.addUserToOrganisation(ckanUsername, role);
    }

    public Role getRole() {
        if (this.role == null) {
            this.role = Role.MEMBER;
            List roles = this.getPortalUser().getRoles();
            for (String portalRole : roles) {
                Role gotRole = Role.getRoleFromPortalRole((String)portalRole);
                if (gotRole == null || gotRole.ordinal() <= this.role.ordinal()) continue;
                this.role = gotRole;
            }
        }
        return this.role;
    }

    public void addUserToOrganization(String organizationName) {
        this.addUserToOrganization(organizationName, this.name, this.getRole().getCkanRole());
    }

    public void addUserToOrganization() {
        String organizationName = CKANOrganization.getCKANOrganizationName();
        this.addUserToOrganization(organizationName);
    }

    public void addToGroup(String groupName) throws WebApplicationException {
        try {
            ObjectNode objectNode = this.mapper.createObjectNode();
            objectNode.put("id", CKANGroup.getCKANGroupName((String)groupName));
            objectNode.put("object", this.name);
            objectNode.put("object_type", "user");
            objectNode.put("capacity", "member");
            this.sendPostRequest("/api/3/action/member_create", this.getAsString((JsonNode)objectNode));
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public PortalUser getPortalUser() {
        if (this.portalUser == null) {
            this.portalUser = new PortalUser();
        }
        return this.portalUser;
    }
}

