/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.persistence.ckan;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.gcube.gcat.persistence.ckan.CKANUser;
import org.gcube.gcat.utils.ContextUtility;

public abstract class CKANUserCache {
    private static final CacheManager cacheManager;
    private static final MutableConfiguration<String, CKANUser> userCacheConfiguration;
    private static final Map<String, Cache<String, CKANUser>> userCachePerContext;

    private CKANUserCache() {
    }

    public static CKANUser getCurrrentCKANUser() {
        String gcubeUsername;
        CKANUser ckanUser;
        String context = ContextUtility.getCurrentContext();
        Cache userCache = (Cache)userCachePerContext.get(context);
        if (userCache == null) {
            userCache = cacheManager.createCache(context, (Configuration)userCacheConfiguration);
            userCachePerContext.put(context, userCache);
        }
        if ((ckanUser = (CKANUser)userCache.get((Object)(gcubeUsername = ContextUtility.getUsername()))) == null) {
            ckanUser = new CKANUser();
            ckanUser.retrieve();
            userCache.put((Object)gcubeUsername, (Object)ckanUser);
        }
        return ckanUser;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        cacheManager.close();
    }

    static {
        CachingProvider provider = Caching.getCachingProvider();
        cacheManager = provider.getCacheManager();
        userCacheConfiguration = new MutableConfiguration().setTypes(String.class, CKANUser.class).setStoreByValue(false).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MINUTES, 15L)));
        userCachePerContext = new HashMap();
    }
}

