/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.ws.WebServiceException;
import org.gcube.gcat.annotation.PATCH;
import org.gcube.gcat.annotation.PURGE;
import org.gcube.gcat.persistence.ckan.CKANGroup;
import org.gcube.gcat.rest.REST;

@Path(value="groups")
public class Group
extends REST<CKANGroup>
implements org.gcube.gcat.api.interfaces.Group<Response, Response> {
    protected static final String GROUP_ID_PARAMETER = "GROUP_ID";

    public Group() {
        super("groups", GROUP_ID_PARAMETER, CKANGroup.class);
    }

    public int count() throws WebServiceException {
        CKANGroup ckan = (CKANGroup)this.getInstance();
        return ckan.count();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="count") @DefaultValue(value="false") Boolean countOnly) {
        if (countOnly.booleanValue()) {
            int count = this.count();
            return this.createCountJson(count);
        }
        return this.list(limit, offset);
    }

    public String list(@QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset) {
        return super.list(limit, offset);
    }

    @POST
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response create(String json) {
        return super.create(json);
    }

    @GET
    @Path(value="/{GROUP_ID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="GROUP_ID") String id) {
        return super.read(id);
    }

    @PUT
    @Path(value="/{GROUP_ID}")
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@PathParam(value="GROUP_ID") String id, String json) {
        return super.update(id, json);
    }

    @PATCH
    @Path(value="/{GROUP_ID}")
    @Consumes(value={"application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String patch(@PathParam(value="GROUP_ID") String id, String json) {
        return super.patch(id, json);
    }

    @DELETE
    @Path(value="/{GROUP_ID}")
    public Response delete(@PathParam(value="GROUP_ID") String id, @QueryParam(value="purge") @DefaultValue(value="false") Boolean purge) {
        return super.delete(id, purge);
    }

    @PURGE
    @Path(value="/{GROUP_ID}")
    public Response purge(@PathParam(value="GROUP_ID") String id) {
        return this.delete(id, true);
    }

    public Response delete(String name, boolean purge) {
        return this.delete(name, new Boolean(purge));
    }
}

