/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.oldutils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.math.NumberUtils;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.DataType;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.MetadataField;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.MetadataFormat;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.MetadataGrouping;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.MetadataTagging;
import org.gcube.datacatalogue.metadatadiscovery.bean.jaxb.NamespaceCategory;
import org.gcube.gcat.oldutils.CustomField;
import org.gcube.gcat.oldutils.Validator;
import org.gcube.gcat.persistence.ckan.CKANGroup;
import org.gcube.gcat.persistence.ckan.CKANUser;
import org.gcube.gcat.persistence.ckan.CKANUtility;
import org.gcube.gcat.profile.MetadataUtility;
import org.geojson.GeoJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Validator {
    private static final Logger logger = LoggerFactory.getLogger(Validator.class);
    private static final SimpleDateFormat DATE_SIMPLE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat DATE_HOUR_MINUTES = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final int MAX_TAG_CHARS = 100;
    protected ObjectMapper mapper;

    public Validator() {
        this.mapper = new ObjectMapper();
    }

    public Validator(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectNode validateAgainstProfile(ObjectNode objectNode, MetadataUtility metadataUtility) throws Exception {
        MetadataFormat profile;
        ArrayNode tagsArrayOriginal;
        ArrayNode extrasArrayOriginal = (ArrayNode)objectNode.get("extras");
        if (extrasArrayOriginal == null || extrasArrayOriginal.size() == 0) {
            throw new BadRequestException("'extras' field is missing in context where metadata profile(s) are defined!");
        }
        ArrayNode groupsArrayOriginal = (ArrayNode)objectNode.get("groups");
        if (groupsArrayOriginal == null) {
            groupsArrayOriginal = this.mapper.createArrayNode();
        }
        if ((tagsArrayOriginal = (ArrayNode)objectNode.get("tags")) == null) {
            tagsArrayOriginal = this.mapper.createArrayNode();
        }
        CustomField metadataTypeCF = null;
        ArrayList<CustomField> customFields = new ArrayList<CustomField>(extrasArrayOriginal.size());
        for (JsonNode object : extrasArrayOriginal) {
            CustomField cf = new CustomField(object);
            if (cf.getKey().equals("system:type")) {
                metadataTypeCF = cf;
                continue;
            }
            if (cf.getKey().equals("Item URL")) continue;
            customFields.add(cf);
        }
        if (metadataTypeCF == null) {
            throw new BadRequestException("'system:type' extra field is missing in context where metadata profile(s) are defined!");
        }
        String profileName = metadataTypeCF.getValue();
        if (metadataUtility == null) {
            metadataUtility = new MetadataUtility();
        }
        if ((profile = metadataUtility.getMetadataFormat(profileName)) == null) {
            throw new BadRequestException("'system:type' extra field's value ('" + profileName + "') specified as custom field doesn't match any of the profiles defined in this context!");
        }
        ArrayNode extrasArrayUpdated = null;
        List metadataFields = profile.getMetadataFields();
        if (metadataFields == null || metadataFields.isEmpty()) {
            extrasArrayUpdated = extrasArrayOriginal;
        } else {
            extrasArrayUpdated = this.mapper.createArrayNode();
            List categories = metadataUtility.getNamespaceCategories();
            logger.debug("Retrieved namespaces are {}", (Object)categories);
            ArrayList<String> categoriesIds = new ArrayList<String>(categories == null ? 0 : categories.size());
            if (categories == null || categories.isEmpty()) {
                logger.warn("No category defined in context {}", (Object)ScopeProvider.instance.get());
            } else {
                for (NamespaceCategory metadataCategory : categories) {
                    categoriesIds.add(metadataCategory.getId());
                }
            }
            ArrayList<CustomField> validatedCustomFields = new ArrayList<CustomField>(customFields.size());
            HashMap fieldsMandatoryLowerBoundMap = new HashMap(metadataFields.size());
            HashMap fieldsMandatoryUpperBoundMap = new HashMap(metadataFields.size());
            HashMap numberFieldsMandatorySameKeyMap = new HashMap(metadataFields.size());
            ArrayList groupsToCreateAfterValidation = new ArrayList();
            int metadataIndex = 0;
            HashMap<String, MetadataField> metadataFieldMap = new HashMap<String, MetadataField>();
            for (MetadataField metadataField : metadataFields) {
                metadataFieldMap.put(metadataField.getFieldName(), metadataField);
                int categoryIdIndex = categoriesIds.indexOf(metadataField.getCategoryRef());
                logger.debug("Found index for category " + metadataField.getCategoryRef() + " " + categoryIdIndex);
                List validCFs = this.validateAgainstMetadataField(metadataIndex, categoryIdIndex, customFields, tagsArrayOriginal, groupsArrayOriginal, metadataField, categories, fieldsMandatoryLowerBoundMap, fieldsMandatoryUpperBoundMap, numberFieldsMandatorySameKeyMap, groupsToCreateAfterValidation);
                validatedCustomFields.addAll(validCFs);
                ++metadataIndex;
            }
            for (Map.Entry entry : fieldsMandatoryLowerBoundMap.entrySet()) {
                int lowerBound = (Integer)entry.getValue();
                String maxOccurs = ((MetadataField)metadataFieldMap.get(entry.getKey())).getMaxOccurs();
                int upperBound = Integer.MAX_VALUE;
                if (maxOccurs.compareTo("*") == 0) {
                    upperBound = Integer.MAX_VALUE;
                } else {
                    try {
                        upperBound = Integer.valueOf(maxOccurs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int inserted = (Integer)numberFieldsMandatorySameKeyMap.get(entry.getKey());
                logger.info("Field with key '" + (String)entry.getKey() + "' has been found " + inserted + " times and its lower bound is " + lowerBound + " and upper bound " + upperBound);
                if (inserted >= lowerBound && inserted <= upperBound) continue;
                throw new BadRequestException("Field with key '" + (String)entry.getKey() + "' is mandatory, but it's not present among the provided fields or its cardinality is not respected ([min = " + lowerBound + ", max=" + upperBound + "]).");
            }
            if (tagsArrayOriginal.size() == 0) {
                throw new BadRequestException("Please define at least one tag for this item!");
            }
            Collections.sort(validatedCustomFields);
            logger.debug("Sorted list of custom fields is " + validatedCustomFields);
            for (CustomField cf : customFields) {
                validatedCustomFields.add(cf);
            }
            for (CustomField customField : validatedCustomFields) {
                ObjectNode jsonObj = this.mapper.createObjectNode();
                jsonObj.put("key", customField.getQualifiedKey());
                jsonObj.put("value", customField.getValue());
                extrasArrayUpdated.add((JsonNode)jsonObj);
            }
            ObjectNode objectNode2 = this.mapper.createObjectNode();
            objectNode2.put("key", metadataTypeCF.getKey());
            objectNode2.put("value", metadataTypeCF.getValue());
            extrasArrayUpdated.add((JsonNode)objectNode2);
            for (String title : groupsToCreateAfterValidation) {
                try {
                    this.createGroupAsSysAdmin(title);
                }
                catch (Exception e) {
                    logger.trace("Failed to create group with title " + title, (Throwable)e);
                }
            }
        }
        objectNode.replace("tags", (JsonNode)tagsArrayOriginal);
        objectNode.replace("groups", (JsonNode)groupsArrayOriginal);
        objectNode.replace("extras", (JsonNode)extrasArrayUpdated);
        return objectNode;
    }

    public void createGroupAsSysAdmin(String title) throws Exception {
        block17: {
            String sysAdminAPI = CKANUtility.getSysAdminAPI();
            CKANGroup ckanGroup = new CKANGroup();
            ckanGroup.setApiKey(sysAdminAPI);
            ckanGroup.setName(CKANGroup.getCKANGroupName((String)title));
            try {
                ckanGroup.read();
            }
            catch (WebApplicationException e) {
                if (e.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                    ckanGroup.create();
                    break block17;
                }
                throw e;
            }
            catch (Exception e) {
                throw new InternalServerErrorException((Throwable)e);
            }
            finally {
                try {
                    this.addUserToGroupAsSysAdmin(title);
                }
                catch (WebApplicationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InternalServerErrorException((Throwable)e);
                }
            }
        }
    }

    public void addUserToGroupAsSysAdmin(String groupName) throws Exception {
        String username = CKANUser.getCKANUsername();
        this.addUserToGroupAsSysAdmin(groupName, username);
    }

    public void addUserToGroupAsSysAdmin(String groupName, String username) throws Exception {
        String sysAdminAPI = CKANUtility.getSysAdminAPI();
        CKANUser ckanUser = new CKANUser();
        ckanUser.setApiKey(sysAdminAPI);
        ckanUser.setName(username);
        ckanUser.addToGroup(CKANGroup.getCKANGroupName((String)groupName));
    }

    private List<CustomField> validateAgainstMetadataField(int metadataIndex, int categoryIndex, List<CustomField> customFields, ArrayNode tagsArrayOriginal, ArrayNode groupsArrayOriginal, MetadataField metadataField, List<NamespaceCategory> categories, Map<String, Integer> fieldsMandatoryLowerBoundMap, Map<String, Integer> fieldsMandatoryUpperBoundMap, Map<String, Integer> numberFieldsMandatorySameKeyMap, List<String> groupToCreate) throws Exception {
        ArrayList<CustomField> toReturn = new ArrayList<CustomField>();
        String metadataFieldName = metadataField.getCategoryFieldQName();
        int fieldsFoundWithThisKey = 0;
        Iterator<CustomField> iterator = customFields.iterator();
        while (iterator.hasNext()) {
            CustomField cf = iterator.next();
            if (!cf.getKey().equals(metadataFieldName)) continue;
            this.validate(cf, metadataField);
            ++fieldsFoundWithThisKey;
            cf.setIndexCategory(categoryIndex);
            cf.setIndexMetadataField(metadataIndex);
            this.checkAsGroup(cf, metadataField, groupsArrayOriginal, groupToCreate);
            this.checkAsTag(cf, metadataField, tagsArrayOriginal);
            toReturn.add(cf);
            iterator.remove();
        }
        if (metadataField.getMandatory().booleanValue()) {
            int upperBound;
            boolean hasVocabulary;
            int lowerBound = 1;
            if (fieldsMandatoryLowerBoundMap.containsKey(metadataFieldName)) {
                lowerBound = fieldsMandatoryLowerBoundMap.get(metadataFieldName) + 1;
            }
            fieldsMandatoryLowerBoundMap.put(metadataFieldName, lowerBound);
            boolean bl = hasVocabulary = metadataField.getVocabulary() != null;
            int n = hasVocabulary ? (metadataField.getVocabulary().isMultiSelection().booleanValue() ? metadataField.getVocabulary().getVocabularyFields().size() : 1) : (upperBound = 1);
            if (fieldsMandatoryUpperBoundMap.containsKey(metadataFieldName)) {
                upperBound += fieldsMandatoryUpperBoundMap.get(metadataFieldName).intValue();
            }
            fieldsMandatoryUpperBoundMap.put(metadataFieldName, upperBound);
            int countPerFields = fieldsFoundWithThisKey;
            if (numberFieldsMandatorySameKeyMap.containsKey(metadataFieldName)) {
                countPerFields += numberFieldsMandatorySameKeyMap.get(metadataFieldName).intValue();
            }
            numberFieldsMandatorySameKeyMap.put(metadataFieldName, countPerFields);
        }
        if (fieldsFoundWithThisKey == 0 && !metadataField.getMandatory().booleanValue()) {
            toReturn.add(new CustomField(metadataFieldName, "", -1, -1));
        }
        return toReturn;
    }

    private void checkAsTag(CustomField fieldToValidate, MetadataField metadataField, ArrayNode tagsArrayOriginal) {
        MetadataTagging tagging = metadataField.getTagging();
        if (tagging != null) {
            String tag = "";
            switch (1.$SwitchMap$org$gcube$datacatalogue$metadatadiscovery$bean$jaxb$TaggingGroupingValue[tagging.getTaggingValue().ordinal()]) {
                case 1: {
                    tag = metadataField.getFieldName();
                    break;
                }
                case 2: {
                    tag = fieldToValidate.getValue();
                    break;
                }
                case 3: {
                    tag = metadataField.getFieldName() + tagging.getSeparator() + fieldToValidate.getValue();
                    break;
                }
                case 4: {
                    tag = fieldToValidate.getValue() + tagging.getSeparator() + metadataField.getFieldName();
                    break;
                }
                default: {
                    return;
                }
            }
            tag = tag.substring(0, 100 > tag.length() ? tag.length() : 100);
            logger.debug("Tag is " + tag);
            ObjectNode tagJSON = this.mapper.createObjectNode();
            tagJSON.put("name", tag);
            tagJSON.put("display_name", tag);
            tagsArrayOriginal.add((JsonNode)tagJSON);
        }
    }

    private void checkAsGroup(CustomField fieldToValidate, MetadataField metadataField, ArrayNode groupsArrayOriginal, List<String> groupToCreate) throws Exception {
        logger.debug("Custom field is " + fieldToValidate);
        logger.debug("MetadataField field is " + metadataField);
        logger.debug("JSONArray field is " + groupsArrayOriginal);
        MetadataGrouping grouping = metadataField.getGrouping();
        if (grouping != null) {
            boolean propagateUp = grouping.getPropagateUp();
            HashSet<String> groupNames = new HashSet<String>();
            switch (1.$SwitchMap$org$gcube$datacatalogue$metadatadiscovery$bean$jaxb$TaggingGroupingValue[grouping.getGroupingValue().ordinal()]) {
                case 1: {
                    groupNames.add(metadataField.getFieldName());
                    break;
                }
                case 2: {
                    if (fieldToValidate.getValue() == null || fieldToValidate.getValue().isEmpty()) break;
                    groupNames.add(fieldToValidate.getValue());
                    break;
                }
                case 3: 
                case 4: {
                    groupNames.add(metadataField.getFieldName());
                    if (fieldToValidate.getValue() == null || fieldToValidate.getValue().isEmpty()) break;
                    groupNames.add(fieldToValidate.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
            for (String title : groupNames) {
                String groupName = CKANGroup.getCKANGroupName((String)title);
                logger.debug("Adding group to which add this item {}", (Object)groupName);
                ObjectNode group = this.mapper.createObjectNode();
                group.put("name", groupName);
                if (propagateUp) {
                    List parents = Validator.getGroupHierarchyNames((String)groupName);
                    for (String parent : parents) {
                        ObjectNode groupP = this.mapper.createObjectNode();
                        groupP.put("name", parent);
                        groupsArrayOriginal.add((JsonNode)groupP);
                    }
                }
                groupsArrayOriginal.add((JsonNode)group);
            }
            if (grouping.getCreate().booleanValue()) {
                for (String title : groupNames) {
                    groupToCreate.add(title);
                }
            }
        }
    }

    private void validate(CustomField fieldToValidate, MetadataField metadataField) throws Exception {
        DataType dataType = metadataField.getDataType();
        String regex = metadataField.getValidator() != null ? metadataField.getValidator().getRegularExpression() : null;
        boolean hasControlledVocabulary = metadataField.getVocabulary() != null;
        String value = fieldToValidate.getValue();
        String key = fieldToValidate.getKey();
        String defaultValue = metadataField.getDefaultValue();
        fieldToValidate.setQualifiedKey(metadataField.getCategoryFieldQName());
        if (value == null || value.isEmpty()) {
            if (metadataField.getMandatory().booleanValue() || hasControlledVocabulary) {
                throw new BadRequestException("Mandatory field with name '" + key + "' doesn't have a value but it is mandatory or has a controlled vocabulary!");
            }
            if (defaultValue != null && !defaultValue.isEmpty()) {
                value = defaultValue;
                fieldToValidate.setValue(defaultValue);
            }
            return;
        }
        switch (1.$SwitchMap$org$gcube$datacatalogue$metadatadiscovery$bean$jaxb$DataType[dataType.ordinal()]) {
            case 1: 
            case 2: {
                String valueVocabulary;
                if (regex != null && !value.matches(regex)) {
                    throw new BadRequestException("Field with key '" + key + "' doesn't match the provided regular expression (" + regex + ")!");
                }
                if (!hasControlledVocabulary) break;
                List valuesVocabulary = metadataField.getVocabulary().getVocabularyFields();
                if (valuesVocabulary == null || valuesVocabulary.isEmpty()) {
                    return;
                }
                boolean match = false;
                Iterator iterator = valuesVocabulary.iterator();
                while (iterator.hasNext() && !(match = value.equals(valueVocabulary = (String)iterator.next()))) {
                }
                if (match) break;
                throw new BadRequestException("Field with key '" + key + "' has a value '" + value + "' but it doesn't match any of the vocabulary's values (" + valuesVocabulary + ")!");
            }
            case 3: {
                if (Validator.isValidDate((String)value)) break;
                throw new BadRequestException("Field with key '" + key + "' doesn't seem a valid time!");
            }
            case 4: {
                String[] timeValues = value.split("/");
                for (int i = 0; i < timeValues.length; ++i) {
                    String time = timeValues[i];
                    if (Validator.isValidDate((String)time)) continue;
                    throw new BadRequestException("Field with key '" + key + "' doesn't seem a valid time interval!");
                }
                break;
            }
            case 5: {
                String[] timeIntervals = value.split(",");
                for (int i = 0; i < timeIntervals.length; ++i) {
                    String[] timeIntervalValues = timeIntervals[i].split("/");
                    if (timeIntervalValues.length > 2) {
                        throw new BadRequestException("Field with key '" + key + "' doesn't seem a valid list of times!");
                    }
                    for (i = 0; i < timeIntervalValues.length; ++i) {
                        String time = timeIntervalValues[i];
                        if (Validator.isValidDate((String)time)) continue;
                        throw new BadRequestException("Field with key '" + key + "' doesn't seem a valid list of times!");
                    }
                }
                break;
            }
            case 6: {
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) break;
                throw new BadRequestException("Field with key '" + key + "' doesn't seem a valid boolean value!");
            }
            case 7: {
                if (NumberUtils.isNumber((String)value)) break;
                throw new BadRequestException("Field's value with key '" + key + "' is not a valid number!");
            }
            case 8: {
                try {
                    new ObjectMapper().readValue(fieldToValidate.getValue(), GeoJsonObject.class);
                    break;
                }
                catch (Exception e) {
                    throw new BadRequestException("GeoJSON field with key '" + key + "' seems not valid!");
                }
            }
        }
    }

    private static boolean isValidDate(String value) {
        try {
            DATE_HOUR_MINUTES.parse(value);
            return true;
        }
        catch (Exception e) {
            logger.debug("failed to parse date with hours and minutes, trying the other one");
            try {
                DATE_SIMPLE.parse(value);
                return true;
            }
            catch (Exception e2) {
                logger.warn("failed to parse date with simple format, returning false");
                return false;
            }
        }
    }

    public static List<String> getGroupHierarchyNames(String groupName) throws Exception {
        CKANGroup ckanGroup = new CKANGroup();
        ckanGroup.setName(groupName);
        return ckanGroup.getGroups();
    }
}

