/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.profile;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.datacatalogue.metadatadiscovery.reader.QueryForResourceUtil;
import org.gcube.gcat.persistence.ckan.CKANUser;
import org.gcube.gcat.persistence.ckan.CKANUserCache;
import org.gcube.gcat.profile.MetadataUtility;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ISProfile {
    public static int PRETTY_PRINT_INDENT_FACTOR = 4;
    private static Logger logger = LoggerFactory.getLogger(ISProfile.class);
    protected ObjectMapper mapper = new ObjectMapper();

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public int count() {
        try {
            return new MetadataUtility().getProfilesNames().size();
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public ArrayNode list() {
        ArrayNode arrayNode = this.mapper.createArrayNode();
        try {
            Set names = new MetadataUtility().getProfilesNames();
            for (String name : names) {
                arrayNode.add(name);
            }
            return arrayNode;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected GenericResource instantiateGenericResource(String name, String xml) throws Exception {
        GenericResource genericResource = new GenericResource();
        GenericResource.Profile profile = genericResource.newProfile();
        profile.type("DataCatalogueMetadata");
        profile.name(name);
        profile.description("Profile create using gCat");
        profile.newBody(xml);
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)genericResource, (Writer)stringWriter);
        logger.debug("The generated {} is\n{}", (Object)GenericResource.class.getSimpleName(), (Object)stringWriter.toString());
        return genericResource;
    }

    protected void createGenericResource(String name, String xml) throws Exception {
        GenericResource genericResource = this.instantiateGenericResource(name, xml);
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        genericResource = (GenericResource)registryPublisher.create((Resource)genericResource);
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)genericResource, (Writer)stringWriter);
        logger.trace("The {} with ID {} has been created \n{}", new Object[]{GenericResource.class.getSimpleName(), genericResource.id(), stringWriter.toString()});
    }

    protected GenericResource getGenericResource(String name) {
        String query = QueryForResourceUtil.getGcubeGenericQueryStringForSecondaryTypeAndName((String)name, (String)"DataCatalogueMetadata");
        QueryBox q = new QueryBox(query);
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List resources = client.submit((Query)q);
        if (resources == null || resources.size() == 0) {
            throw new InternalServerErrorException("No Resources with secondaryType 'DataCatalogueMetadata' and name '" + name + "' exists in the current context");
        }
        if (resources.size() == 1) {
            GenericResource genericResource = (GenericResource)resources.get(0);
            return genericResource;
        }
        throw new InternalServerErrorException("More than one Resource with secondaryType 'DataCatalogueMetadata' and name '" + name + "' exists in the current context");
    }

    protected void updateGenericResource(String name, String xml) {
        GenericResource genericResource = this.getGenericResource(name);
        logger.info("The {} with ID {} is going to be updated", (Object)GenericResource.class.getSimpleName(), (Object)genericResource.id());
        genericResource.profile().newBody(xml);
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        registryPublisher.update((Resource)genericResource);
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)genericResource, (Writer)stringWriter);
        logger.trace("The {} with ID {} has been updated to \n{}", new Object[]{GenericResource.class.getSimpleName(), genericResource.id(), stringWriter.toString()});
    }

    protected void removeGenericResource(String name) {
        GenericResource genericResource = this.getGenericResource(name);
        RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
        registryPublisher.remove((Resource)genericResource);
    }

    public String read(String name, boolean xml) {
        try {
            String profile = new MetadataUtility().getMetadataFormat(name).getMetadataSource();
            if (profile != null) {
                if (xml) {
                    return profile;
                }
                JSONObject xmlJSONObj = XML.toJSONObject((String)profile);
                String jsonString = xmlJSONObj.toString(PRETTY_PRINT_INDENT_FACTOR);
                return jsonString;
            }
            throw new NotFoundException("Profile with name " + name + " not found");
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createOrUpdate(String name, String xml) throws SAXException {
        try {
            CKANUser ckanUser = CKANUserCache.getCurrrentCKANUser();
            if (ckanUser.getRole().ordinal() < CKANUser.Role.ADMIN.ordinal()) {
                throw new NotAuthorizedException((Object)"You are not authorized to manage profiles, only Catalogue Editor can manipulate profiles.", new Object[0]);
            }
            MetadataUtility metadataUtility = new MetadataUtility();
            metadataUtility.validateProfile(xml);
            if (metadataUtility.getMetadataFormat(name) == null) {
                this.createGenericResource(name, xml);
                return true;
            }
            this.updateGenericResource(name, xml);
            return false;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(String name) {
        try {
            CKANUser ckanUser = CKANUserCache.getCurrrentCKANUser();
            if (ckanUser.getRole().ordinal() < CKANUser.Role.EDITOR.ordinal()) {
                throw new NotAuthorizedException((Object)"You are not authorized to manage profiles, only Catalogue Editor can manipulate profiles.", new Object[0]);
            }
            MetadataUtility metadataUtility = new MetadataUtility();
            if (metadataUtility.getMetadataFormat(name) == null) {
                throw new NotFoundException("Profile with name " + name + " not found");
            }
            this.removeGenericResource(name);
            return true;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
    }
}

