/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.testing;

import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasink.DataSinkOp;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc.QueryParser;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.testing.TestDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class TestDataSink {
    public static void main(String[] args) throws Exception {
        URI uri = TestDataSource.testJDBCSource();
        uri = new URI(TestDataSink.testgrs2Sink(uri));
        TestDataSink.testLocalSink(uri);
    }

    public static String testLocalSink(URI uri) throws Exception {
        String outputType = "Path";
        String outputValue = "/home/jgerbe/Desktop";
        new File(outputValue).delete();
        Map<String, String> outputParameters = null;
        StatsContainer stats = new StatsContainer();
        DataSinkOp ds = new DataSinkOp(uri, outputType, outputValue, outputParameters, stats);
        return ds.compute();
    }

    private static String testFTPSink(URI uri) throws Exception {
        String outputType = "FTP";
        String outputValue = "meteora.di.uoa.gr";
        HashMap<String, String> outputParameters = new HashMap<String, String>();
        outputParameters.put("username", "giannis");
        outputParameters.put("password", "aplagiaftp");
        outputParameters.put("directory", "testArea/dest");
        StatsContainer stats = new StatsContainer();
        DataSinkOp ds = new DataSinkOp(uri, outputType, outputValue, (Map<String, String>)outputParameters, stats);
        return ds.compute();
    }

    public static String testJDBCSink(URI uri) throws Exception {
        String queryString = new String("<q><query>insert into trees values (?, ?, ?, ?)</query><driverName>org.postgresql.Driver</driverName><connectionString>jdbc:postgresql://localhost:5432/dellstore2?user=postgres&amp;password=aplagiadb</connectionString></q>");
        QueryParser queryParser = new QueryParser(queryString);
        System.out.println("driver: " + queryParser.getDriverName());
        System.out.println("query: " + queryParser.getQuery());
        System.out.println("connection url: " + queryParser.getConnectionString());
        String outputType = "JDBC";
        String outputValue = queryString;
        HashMap<String, String> outputParameters = new HashMap<String, String>();
        StatsContainer stats = new StatsContainer();
        DataSinkOp ds = new DataSinkOp(uri, outputType, outputValue, (Map<String, String>)outputParameters, stats);
        return ds.compute();
    }

    public static String testgrs2Sink(URI uri) throws Exception {
        String outputType = "GRS2";
        HashMap<String, String> outputParameters = new HashMap<String, String>();
        outputParameters.put("delimiter", Character.toString('\u0002'));
        StatsContainer stats = new StatsContainer();
        DataSinkOp ds = new DataSinkOp(uri, outputType, "", (Map<String, String>)outputParameters, stats);
        return ds.compute();
    }

    private static String inputStreamToString(InputStream inputStream) throws IOException {
        InputStream in = inputStream;
        InputStreamReader is = new InputStreamReader(in);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(is);
        String read = br.readLine();
        while (read != null) {
            sb.append(read);
            read = br.readLine();
        }
        return sb.toString();
    }
}

