/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasink.predefined;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.FieldNaming;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasink.DataSink;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPDataSink<T extends Record>
extends DataSink {
    private static final String PARAMETER_DirectoryName = "directory";
    private static final String PARAMETER_Username = "username";
    private static final String PARAMETER_Password = "password";
    private static final String PARAMETER_Port = "port";
    private static Logger log = LoggerFactory.getLogger((String)FTPDataSink.class.getName());
    private FTPClient ftpClient = new FTPClient();
    private String server;
    private int port;
    private String username = "anonymous";
    private String password = "anonymous";
    private String directory = "";
    private IRecordReader<T> reader = null;

    public FTPDataSink(URI inLocator, String output, Map<String, String> outputParameters, StatsContainer statsCont) throws Exception {
        super(inLocator, output, outputParameters, statsCont);
        this.reader = new ForwardReader(inLocator);
        RecordDefinition defs = this.reader.getRecordDefinitions()[0];
        if (defs.getDefinition(FieldNaming.FTPFieldName.id.name()) < 0 || defs.getDefinition(FieldNaming.FTPFieldName.bytestream.name()) < 0 || defs.getDefinition(FieldNaming.FTPFieldName.mimeType.name()) < 0) {
            log.error("FTPDataSink could not be initialized, cause corresponding fields are missing from resultSet");
            throw new Exception("FTPDataSink could not be initialized, cause corresponding fields are missing from resultSet");
        }
        this.server = output;
        this.port = this.ftpClient.getDefaultPort();
        this.directory = "";
        if (outputParameters != null && outputParameters.size() > 0) {
            for (Map.Entry<String, String> param : outputParameters.entrySet()) {
                if (param.getKey() == null || param.getKey().trim().length() <= 0 || param.getValue() == null) continue;
                if (param.getKey().equals(PARAMETER_DirectoryName)) {
                    this.directory = param.getValue();
                    if (this.directory.endsWith("/")) continue;
                    this.directory = this.directory + "/";
                    continue;
                }
                if (param.getKey().equals(PARAMETER_Username)) {
                    this.username = param.getValue();
                    continue;
                }
                if (param.getKey().equals(PARAMETER_Password)) {
                    this.password = param.getValue();
                    continue;
                }
                if (!param.getKey().equals(PARAMETER_Port)) continue;
                this.port = Integer.parseInt(param.getValue());
            }
        }
        log.info("Ininializing ftp data sink at: " + this.username + "@" + this.server + ":" + this.port + "/" + this.directory);
        this.ftpClient.connect(this.server, this.port);
        this.ftpClient.login(this.username, this.password);
        this.ftpClient.setFileType(2);
        log.info("Connected to " + this.server + ".");
        log.info("FTP server replied: " + this.ftpClient.getReplyString());
        int replyCode = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            log.error("FTP server refused connection. Reply CODE: " + replyCode);
            this.ftpClient.disconnect();
            throw new Exception("FTP server refused connection. Reply CODE: " + replyCode);
        }
        this.output = "ftp://" + this.server + "/" + this.directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rc;
        long firstOutputStop;
        long firstInputStop;
        long start;
        block24: {
            firstInputStop = start = Calendar.getInstance().getTimeInMillis();
            firstOutputStop = start;
            rc = 0;
            try {
                while (true) {
                    try {
                        while (this.reader.getStatus() != IBuffer.Status.Dispose) {
                            String contentType;
                            File payload;
                            String recordId;
                            block25: {
                                if (this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                                    break block24;
                                }
                                Record rec = this.reader.get(this.timeout, this.timeUnit);
                                if (rec == null) {
                                    if (this.reader.getStatus() == IBuffer.Status.Open) {
                                        log.warn("Producer has timed out");
                                    }
                                    break block24;
                                }
                                if (rc == 0) {
                                    firstInputStop = Calendar.getInstance().getTimeInMillis();
                                }
                                recordId = null;
                                payload = null;
                                contentType = "";
                                try {
                                    Field contentTypeField;
                                    Field payloadField;
                                    Field recIdField = rec.getField(FieldNaming.FTPFieldName.id.name());
                                    if (recIdField instanceof StringField) {
                                        recordId = ((StringField)recIdField).getPayload();
                                    }
                                    if ((payloadField = rec.getField(FieldNaming.FTPFieldName.bytestream.name())) instanceof FileField) {
                                        payload = ((FileField)payloadField).getPayload();
                                    }
                                    if (!((contentTypeField = rec.getField(FieldNaming.FTPFieldName.mimeType.name())) instanceof StringField)) break block25;
                                    contentType = ((StringField)contentTypeField).getPayload();
                                }
                                catch (Exception e) {
                                    log.warn("Could not extract payload from record #" + rc + ". Continuing");
                                    continue;
                                }
                            }
                            String filename = recordId.hashCode() + contentType.replaceAll("/", ".");
                            String remoteFilename = this.directory + filename;
                            this.storeFTPFile(remoteFilename, payload);
                            if (++rc != 1) continue;
                            firstOutputStop = Calendar.getInstance().getTimeInMillis();
                        }
                    }
                    catch (Exception e) {
                        log.warn("Could not retrieve and store the record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("Error during datasink retrieval. Closing", (Throwable)e);
            }
            finally {
                try {
                    this.reader.close();
                    if (this.ftpClient.isConnected()) {
                        this.ftpClient.disconnect();
                    }
                }
                catch (Exception ee) {}
            }
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closeStop - start);
        this.stats.timeToFirstInput(firstInputStop - start);
        this.stats.timeToFirst(firstOutputStop - start);
        this.stats.producedResults((long)rc);
        this.stats.productionRate((float)rc / (float)(closeStop - start) * 1000.0f);
        log.info("DATASINK OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }

    public void storeFTPFile(String remoteFilename, File payload) {
        int tries = 0;
        while (true) {
            log.debug("Storing element as " + remoteFilename);
            try {
                FileInputStream stream = new FileInputStream(payload);
                if (stream != null) {
                    boolean res = this.ftpClient.storeFile(remoteFilename, (InputStream)stream);
                    if (res) {
                        log.debug("Data element stored succesfuly at " + remoteFilename);
                    } else {
                        log.warn("Data element was not stored succesfuly at " + remoteFilename);
                    }
                    ((InputStream)stream).close();
                }
                return;
            }
            catch (Exception e) {
                if (tries == 3) {
                    log.error("Did not manage to append element in the data sink");
                    return;
                }
                ++tries;
                log.warn("Did not manage to append element in the data sink, reconnecting and trying again...", (Throwable)e);
                try {
                    this.reconnect();
                }
                catch (Exception e1) {
                    log.error("Did not manage to reconnect to the ftp site", (Throwable)e1);
                    return;
                }
            }
        }
    }

    private void reconnect() throws Exception {
        this.ftpClient.connect(this.server, this.port);
        this.ftpClient.login(this.username, this.password);
        this.ftpClient.setFileType(2);
    }

    @Override
    public String getOutput() {
        return this.output;
    }
}

