/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.grs2;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.FieldNaming;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.Unary;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRS2Splitter
extends Unary
implements Runnable {
    private static Logger log = LoggerFactory.getLogger((String)GRS2Splitter.class.getName());
    private IRecordReader<Record> reader;
    private File sourceFile;
    private String delimiter = "\\" + Character.toString('\u0001');
    private String filterMask;
    private RecordWriter<Record> writer;
    private FieldDefinition[] fieldDefs;

    public GRS2Splitter(URI inLocator, Map<String, String> operatorParameters, StatsContainer stats) throws Exception {
        super(inLocator, operatorParameters, stats);
        if (operatorParameters != null) {
            this.filterMask = operatorParameters.get("filterMask");
            if (operatorParameters.get("delimiter") != null) {
                this.delimiter = "\\" + Character.toString(operatorParameters.get("delimiter").charAt(0));
            }
        }
    }

    public GRS2Splitter(URI inLocator, Map<String, String> inputParameters, StatsContainer stats, long timeout, TimeUnit timeUnit) throws Exception {
        super(inLocator, inputParameters, stats, timeout, timeUnit);
    }

    public URI compute() throws Exception {
        this.reader = new ForwardReader(this.inLocator);
        if (this.filterMask == null) {
            this.sourceFile = GRS2Splitter.retrieveNextFileFromRS(this.reader);
            this.filterMask = this.sourceFile != null ? GRS2Splitter.initializeMask(this.sourceFile.getAbsolutePath(), this.delimiter) : "";
        }
        this.fieldDefs = GRS2Splitter.initializeSchema(this.filterMask);
        this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(this.fieldDefs)}, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        new Thread(this).start();
        return this.writer.getLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rc;
        long firstOutputStop;
        long firstInputStop;
        long start;
        block26: {
            firstInputStop = start = Calendar.getInstance().getTimeInMillis();
            firstOutputStop = start;
            rc = 0;
            try {
                if (this.sourceFile == null) {
                    this.sourceFile = GRS2Splitter.retrieveNextFileFromRS(this.reader);
                }
                block15: while (this.sourceFile != null) {
                    log.debug("retrieving records from file: " + this.sourceFile);
                    if (rc == 0) {
                        firstInputStop = Calendar.getInstance().getTimeInMillis();
                    }
                    GenericRecord rec = null;
                    int ln = 1;
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader(this.sourceFile));
                        while ((line = br.readLine()) != null) {
                            String[] toks;
                            ArrayList<StringField> fieldList = new ArrayList<StringField>();
                            String[] stringArray = toks = line.endsWith(this.delimiter.substring(1)) ? (line + " ").split(this.delimiter) : line.split(this.delimiter);
                            if (line.endsWith(this.delimiter.substring(1))) {
                                toks[toks.length - 1] = "";
                            }
                            if (toks.length != this.fieldDefs.length) {
                                log.warn("line contains " + toks.length + " instead of " + this.fieldDefs.length + ". moving to next");
                            }
                            boolean empty = true;
                            for (FieldDefinition fd : this.fieldDefs) {
                                Matcher m = Pattern.compile("\\d+$").matcher(fd.getName());
                                int fn = -1;
                                if (m.find()) {
                                    fn = Integer.parseInt(m.group());
                                }
                                try {
                                    fieldList.add(new StringField(toks[fn]));
                                    if (toks[fn].isEmpty()) continue;
                                    empty = false;
                                }
                                catch (Exception e) {
                                    log.warn("Field: " + fd.getName() + " can not be retrieved from file: " + this.sourceFile + " line: " + line);
                                    this.sourceFile = GRS2Splitter.retrieveNextFileFromRS(this.reader);
                                    continue block15;
                                }
                            }
                            if (empty) {
                                log.debug("skipping empty record");
                                continue;
                            }
                            rec = new GenericRecord();
                            rec.setFields(fieldList.toArray(new Field[fieldList.size()]));
                            ++ln;
                            if (!this.writer.importRecord((Record)rec, this.timeout, this.timeUnit)) {
                                if (this.writer.getStatus() == IBuffer.Status.Open) {
                                    log.warn("Consumer has timed out");
                                }
                                break block26;
                            }
                            if (++rc != 1) continue;
                            firstOutputStop = Calendar.getInstance().getTimeInMillis();
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        log.warn("could not read source file: " + this.sourceFile);
                    }
                    this.sourceFile = GRS2Splitter.retrieveNextFileFromRS(this.reader);
                }
            }
            catch (Exception e) {
                log.error("Error during source retrieval. Closing", (Throwable)e);
            }
            finally {
                try {
                    this.reader.close();
                    this.writer.close();
                }
                catch (Exception ee) {}
            }
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closeStop - start);
        this.stats.timeToFirstInput(firstInputStop - start);
        this.stats.timeToFirst(firstOutputStop - start);
        this.stats.producedResults((long)rc);
        this.stats.productionRate((float)rc / (float)(closeStop - start) * 1000.0f);
        log.info("GRS2SPLITTER OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }

    private static FieldDefinition[] initializeSchema(String filterMask) {
        ArrayList<StringFieldDefinition> fieldDefsList = new ArrayList<StringFieldDefinition>();
        for (String ref : filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
            if (ref.equals("bytestream")) {
                log.warn("No file field is allowed");
                continue;
            }
            fieldDefsList.add(new StringFieldDefinition(ref));
        }
        log.info("ResultSet schema that will be used: " + fieldDefsList);
        return fieldDefsList.toArray(new FieldDefinition[fieldDefsList.size()]);
    }

    private static String initializeMask(String fName, String delimiter) {
        int stringFieldsNum;
        String line = null;
        String filterMask = null;
        File f = new File(fName);
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            line = br.readLine();
            if (line != null) {
                // empty if block
            }
            br.close();
        }
        catch (IOException e) {
            log.warn("could not read source");
        }
        try {
            stringFieldsNum = line.split(delimiter).length;
        }
        catch (Exception e) {
            log.error("Wrong delimiter", (Throwable)e);
            return null;
        }
        filterMask = "[";
        for (int i = 0; i < stringFieldsNum; ++i) {
            filterMask = filterMask + "field" + i + ", ";
        }
        filterMask = filterMask.substring(0, filterMask.length() - 2);
        filterMask = filterMask + "]";
        return filterMask;
    }

    private static File retrieveNextFileFromRS(IRecordReader<Record> reader) throws Exception {
        File sourceFile = null;
        Record rec = null;
        while (rec == null && reader.getStatus() != IBuffer.Status.Dispose && (reader.getStatus() != IBuffer.Status.Close || reader.availableRecords() != 0)) {
            rec = reader.get(600L, TimeUnitDef);
            if (rec != null) continue;
            if (reader.getStatus() != IBuffer.Status.Open) break;
            log.warn("Reader has timeout. Continue to wait");
        }
        if (rec == null) {
            return null;
        }
        Field payloadField = rec.getField(FieldNaming.LocalFieldName.bytestream.name());
        if (payloadField == null || !(payloadField instanceof FileField)) {
            throw new Exception("Record does not contain any file field");
        }
        sourceFile = ((FileField)payloadField).getPayload();
        return sourceFile;
    }
}

