/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.client.library.proxies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.datatransformation.client.library.beans.Types;
import org.gcube.datatransformation.client.library.exceptions.DTSException;
import org.gcube.datatransformation.client.library.proxies.DTSCLProxyI;
import org.gcube.datatransformation.client.library.stubs.DTSStub;

public class DTSCLDefaultProxy
implements DTSCLProxyI {
    private final ProxyDelegate<DTSStub> delegate;

    public DTSCLDefaultProxy(ProxyDelegate<DTSStub> config) {
        this.delegate = config;
    }

    @Override
    public String transformData(final String inputType, final String inputValue, final Map<String, String> inputParams, final String outputType, final String outputValue, final Map<String, String> outputParams, final String mimeType, final Map<String, String> contentTypeParams, final boolean createReport) throws DTSException {
        Call<DTSStub, Types.TransformDataResponse> call = new Call<DTSStub, Types.TransformDataResponse>(){

            public Types.TransformDataResponse call(DTSStub endpoint) throws Exception {
                Types.TransformData request = new Types.TransformData();
                Types.Input input = new Types.Input();
                input.inputType = inputType;
                input.inputValue = inputValue;
                ArrayList<Types.Parameter> inputparameters = new ArrayList<Types.Parameter>();
                for (Map.Entry param : inputParams.entrySet()) {
                    Types.Parameter inputparameter = new Types.Parameter();
                    inputparameter.name = (String)param.getKey();
                    inputparameter.value = (String)param.getValue();
                    inputparameters.add(inputparameter);
                }
                input.inputparameters = inputparameters;
                request.input = input;
                Types.Output output = new Types.Output();
                output.outputType = outputType;
                output.outputValue = outputValue;
                ArrayList<Types.Parameter> outputTypeParameters = new ArrayList<Types.Parameter>();
                for (Map.Entry param : outputParams.entrySet()) {
                    Types.Parameter inputparameter = new Types.Parameter();
                    inputparameter.name = (String)param.getKey();
                    inputparameter.value = (String)param.getValue();
                    outputTypeParameters.add(inputparameter);
                }
                output.outputparameters = outputTypeParameters;
                request.output = output;
                Types.ContentType targetContentType = new Types.ContentType();
                targetContentType.mimeType = mimeType;
                ArrayList<Types.Parameter> contentTypeParameters = new ArrayList<Types.Parameter>();
                for (Map.Entry param : contentTypeParams.entrySet()) {
                    Types.Parameter contentTypeParams2 = new Types.Parameter();
                    contentTypeParams2.name = (String)param.getKey();
                    contentTypeParams2.value = (String)param.getValue();
                    inputparameters.add(contentTypeParams2);
                }
                targetContentType.parameters = contentTypeParameters;
                request.targetContentType = targetContentType;
                request.createReport = createReport;
                return endpoint.transformData(request);
            }
        };
        Types.TransformDataResponse transformDataResponse = null;
        try {
            transformDataResponse = (Types.TransformDataResponse)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new DTSException(e);
        }
        String output = transformDataResponse.output;
        return output;
    }

    @Override
    public String transformDataWithTransformationUnit(final String transformationProgramID, final String transformationUnitID, final Map<Map.Entry<String, String>, Map<String, String>> inputs, final String outputType, final String outputValue, final Map<String, String> outputParams, final String mimeType, final Map<String, String> contentTypeParams, final Map<String, String> tProgramUnboundParameters, final boolean filterSources, final boolean createReport) {
        Call<DTSStub, Types.TransformDataWithTransformationUnitResponse> call = new Call<DTSStub, Types.TransformDataWithTransformationUnitResponse>(){

            public Types.TransformDataWithTransformationUnitResponse call(DTSStub endpoint) throws Exception {
                Types.TransformDataWithTransformationUnit request = new Types.TransformDataWithTransformationUnit();
                request.tpID = transformationProgramID;
                request.transformationUnitID = transformationUnitID;
                ArrayList<Types.Input> inputList = new ArrayList<Types.Input>();
                for (Map.Entry inputIter : inputs.entrySet()) {
                    Types.Input input = new Types.Input();
                    input.inputType = (String)((Map.Entry)inputIter.getKey()).getKey();
                    input.inputValue = (String)((Map.Entry)inputIter.getKey()).getValue();
                    ArrayList<Types.Parameter> inputTypeParameters = new ArrayList<Types.Parameter>();
                    if (inputIter.getValue() != null) {
                        for (Map.Entry param : ((Map)inputIter.getValue()).entrySet()) {
                            Types.Parameter inputparameter = new Types.Parameter();
                            inputparameter.name = (String)param.getKey();
                            inputparameter.value = (String)param.getValue();
                            inputTypeParameters.add(inputparameter);
                        }
                    }
                    input.inputparameters = inputTypeParameters;
                    inputList.add(input);
                }
                request.inputs = inputList;
                Types.Output output = new Types.Output();
                output.outputType = outputType;
                output.outputValue = outputValue;
                ArrayList<Types.Parameter> outputTypeParameters = new ArrayList<Types.Parameter>();
                if (outputParams != null) {
                    for (Map.Entry param : outputParams.entrySet()) {
                        Types.Parameter outputparameter = new Types.Parameter();
                        outputparameter.name = (String)param.getKey();
                        outputparameter.value = (String)param.getValue();
                        outputTypeParameters.add(outputparameter);
                    }
                }
                output.outputparameters = outputTypeParameters;
                request.output = output;
                Types.ContentType targetContentType = new Types.ContentType();
                targetContentType.mimeType = mimeType;
                ArrayList<Types.Parameter> contentTypeParameters = new ArrayList<Types.Parameter>();
                Set contentParamSet = contentTypeParams.entrySet();
                for (Map.Entry param : contentParamSet) {
                    Types.Parameter contentTypeParameter = new Types.Parameter();
                    contentTypeParameter.name = (String)param.getKey();
                    contentTypeParameter.value = (String)param.getValue();
                    contentTypeParameters.add(contentTypeParameter);
                }
                targetContentType.parameters = contentTypeParameters;
                request.targetContentType = targetContentType;
                ArrayList<Types.Parameter> tProgramUnboundParameterList = new ArrayList<Types.Parameter>();
                for (Map.Entry param : tProgramUnboundParameters.entrySet()) {
                    Types.Parameter tProgramUnboundParameter = new Types.Parameter();
                    tProgramUnboundParameter.name = (String)param.getKey();
                    tProgramUnboundParameter.value = (String)param.getValue();
                    tProgramUnboundParameterList.add(tProgramUnboundParameter);
                }
                request.tProgramUnboundParameters = tProgramUnboundParameterList;
                request.filterSources = filterSources;
                request.createReport = createReport;
                return endpoint.transformDataWithTransformationUnit(request);
            }
        };
        try {
            Types.TransformDataWithTransformationUnitResponse transformDataWithTransformationUnitResponse = (Types.TransformDataWithTransformationUnitResponse)this.delegate.make((Call)call);
            String output = transformDataWithTransformationUnitResponse.output;
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String transformDataWithTransformationProgram(final String transformationProgramID, final String inputType, final String inputValue, final Map<String, String> inputParams, final String outputType, final String outputValue, final Map<String, String> outputParams, final String mimeType, final Map<String, String> contentTypeParams, final Map<String, String> tProgramUnboundParameters, final boolean createReport) {
        Call<DTSStub, Types.TransformDataWithTransformationProgramResponse> call = new Call<DTSStub, Types.TransformDataWithTransformationProgramResponse>(){

            public Types.TransformDataWithTransformationProgramResponse call(DTSStub endpoint) throws Exception {
                Types.TransformDataWithTransformationProgram request = new Types.TransformDataWithTransformationProgram();
                request.tpID = transformationProgramID;
                Types.Input input = new Types.Input();
                input.inputType = inputType;
                input.inputValue = inputValue;
                ArrayList<Types.Parameter> inputTypeParameters = new ArrayList<Types.Parameter>();
                for (Map.Entry param : inputParams.entrySet()) {
                    Types.Parameter inputparameter = new Types.Parameter();
                    inputparameter.name = (String)param.getKey();
                    inputparameter.value = (String)param.getValue();
                    inputTypeParameters.add(inputparameter);
                }
                input.inputparameters = inputTypeParameters;
                request.input = input;
                Types.Output output = new Types.Output();
                output.outputType = outputType;
                output.outputValue = outputValue;
                ArrayList<Types.Parameter> outputTypeParameters = new ArrayList<Types.Parameter>();
                for (Map.Entry param : outputParams.entrySet()) {
                    Types.Parameter outputparameter = new Types.Parameter();
                    outputparameter.name = (String)param.getKey();
                    outputparameter.value = (String)param.getValue();
                    outputTypeParameters.add(outputparameter);
                }
                output.outputparameters = outputTypeParameters;
                request.output = output;
                Types.ContentType targetContentType = new Types.ContentType();
                targetContentType.mimeType = mimeType;
                ArrayList<Types.Parameter> contentTypeParameters = new ArrayList<Types.Parameter>();
                for (Map.Entry param : contentTypeParams.entrySet()) {
                    Types.Parameter contentTypeParameter = new Types.Parameter();
                    contentTypeParameter.name = (String)param.getKey();
                    contentTypeParameter.value = (String)param.getValue();
                    contentTypeParameters.add(contentTypeParameter);
                }
                targetContentType.parameters = contentTypeParameters;
                request.targetContentType = targetContentType;
                ArrayList<Types.Parameter> tProgramUnboundParameterList = new ArrayList<Types.Parameter>();
                for (Map.Entry param : tProgramUnboundParameters.entrySet()) {
                    Types.Parameter tProgramUnboundParameter = new Types.Parameter();
                    tProgramUnboundParameter.name = (String)param.getKey();
                    tProgramUnboundParameter.value = (String)param.getValue();
                    tProgramUnboundParameterList.add(tProgramUnboundParameter);
                }
                request.tProgramUnboundParameters = tProgramUnboundParameterList;
                request.createReport = createReport;
                return endpoint.transformDataWithTransformationProgram(request);
            }
        };
        try {
            Types.TransformDataWithTransformationProgramResponse transformDataWithTransformationProgramResponse = (Types.TransformDataWithTransformationProgramResponse)this.delegate.make((Call)call);
            String output = transformDataWithTransformationProgramResponse.output;
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, String> findApplicableTransformationUnits(final String sourceMimeType, final Map<String, String> sourceContentTypeParams, final String targetMimeType, final Map<String, String> targetContentTypeParams, final boolean createAndPublishCompositeTP) {
        Call<DTSStub, Types.FindApplicableTransformationUnitsResponse> call = new Call<DTSStub, Types.FindApplicableTransformationUnitsResponse>(){

            public Types.FindApplicableTransformationUnitsResponse call(DTSStub endpoint) throws Exception {
                Types.FindApplicableTransformationUnits request = new Types.FindApplicableTransformationUnits();
                Types.ContentType sourceContentType = new Types.ContentType();
                sourceContentType.mimeType = sourceMimeType;
                ArrayList<Types.Parameter> sourceContentTypeParameterList = new ArrayList<Types.Parameter>();
                if (sourceContentTypeParams != null) {
                    for (Map.Entry param : sourceContentTypeParams.entrySet()) {
                        Types.Parameter contentTypeParameter = new Types.Parameter();
                        contentTypeParameter.name = (String)param.getKey();
                        contentTypeParameter.value = (String)param.getValue();
                        sourceContentTypeParameterList.add(contentTypeParameter);
                    }
                }
                sourceContentType.parameters = sourceContentTypeParameterList;
                request.sourceContentType = sourceContentType;
                Types.ContentType targetContentType = new Types.ContentType();
                targetContentType.mimeType = targetMimeType;
                ArrayList<Types.Parameter> targetContentTypeParameterList = new ArrayList<Types.Parameter>();
                if (targetContentTypeParams != null) {
                    for (Map.Entry param : targetContentTypeParams.entrySet()) {
                        Types.Parameter contentTypeParameter = new Types.Parameter();
                        contentTypeParameter.name = (String)param.getKey();
                        contentTypeParameter.value = (String)param.getValue();
                        targetContentTypeParameterList.add(contentTypeParameter);
                    }
                }
                targetContentType.parameters = targetContentTypeParameterList;
                request.targetContentType = targetContentType;
                request.createAndPublishCompositeTP = createAndPublishCompositeTP;
                return endpoint.findApplicableTransformationUnits(request);
            }
        };
        try {
            Types.FindApplicableTransformationUnitsResponse findApplicableTransformationUnitsResponse = (Types.FindApplicableTransformationUnitsResponse)this.delegate.make((Call)call);
            List<Types.TPAndTransformationUnit> tpAndTransformationUnit = findApplicableTransformationUnitsResponse.TPAndTransformationUnitIDs;
            HashMap<String, String> output = new HashMap<String, String>();
            for (Types.TPAndTransformationUnit iter : tpAndTransformationUnit) {
                output.put(iter.transformationProgramID, iter.transformationUnitID);
            }
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String queryTransformationPrograms(final String query) {
        Call<DTSStub, String> call = new Call<DTSStub, String>(){

            public String call(DTSStub endpoint) throws Exception {
                return endpoint.queryTransformationPrograms(query);
            }
        };
        try {
            String response = (String)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

