package org.gcube.datatransformation.client.library.plugins;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.datatransformation.client.library.proxies.DTSCLDefaultProxy;
import org.gcube.datatransformation.client.library.proxies.DTSCLProxyI;
import org.gcube.datatransformation.client.library.stubs.DTSStub;
import org.gcube.datatransformation.client.library.utils.DTSCLConstants;

/**
 * DTS Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of DTS CL. 
 * 
 * @author john.gerbesiotis - DI NKUA
 * 
 */
public class DTSCLPlugin implements Plugin<DTSStub, DTSCLProxyI> {

	@Override
	public String name() {
		return DTSCLConstants.NAME;
	}

	@Override
	public String namespace() {
		return DTSCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return DTSCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return DTSCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public DTSStub resolve(EndpointReference reference, ProxyConfig<?, ?> proxyConfig) throws Exception {
		return StubFactory.stubFor(DTSCLConstants.dts).at(reference);
	}

	@Override
	public DTSCLProxyI newProxy(ProxyDelegate<DTSStub> delegate) {
		return new DTSCLDefaultProxy(delegate);
	}

}
