/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.elasticsearch.loaders;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class Aliases {
    private static final String ALIAS_FOLDER = "schema_alias/";
    private static Map<String, Properties> aliasesProperties;
    private static boolean isInit;
    private static final Logger logger;

    public static synchronized void init() {
        aliasesProperties = new ConcurrentHashMap<String, Properties>();
        URL aliasUrl = Thread.currentThread().getContextClassLoader().getResource(ALIAS_FOLDER);
        URI aliasFilePath = null;
        if (aliasUrl != null) {
            try {
                aliasFilePath = aliasUrl.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (aliasFilePath != null) {
            File dir = new File(aliasFilePath);
            if (dir.exists() && dir.isDirectory()) {
                for (File file : dir.listFiles()) {
                    try {
                        aliasesProperties.put(file.getName().replace(".properties", ""), Aliases.readProperties(file.toURI()));
                    }
                    catch (IOException e) {
                        logger.info((Object)"Could not load a json transformer");
                    }
                }
            }
            logger.debug((Object)("Found " + aliasesProperties.size() + " aliasMapings in the classpath"));
        } else {
            logger.error((Object)("Could not load the folder containing the alias mappings... No " + aliasUrl + " folder found within the classpath."));
        }
    }

    public static Map<String, Properties> getAllAliases() {
        if (!isInit) {
            Aliases.init();
        }
        return aliasesProperties;
    }

    private static synchronized Properties readProperties(URI path) throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(new File(path)));
        return props;
    }

    static {
        isInit = false;
        logger = Logger.getLogger(Aliases.class);
    }
}

