/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.elasticsearch;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.JsonUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.core.db.HarvestedInfoObject;
import org.gcube.datatransformation.harvester.core.db.ManagerOfHarvested;
import org.gcube.datatransformation.harvester.elasticsearch.XML;
import org.gcube.datatransformation.harvester.elasticsearch.loaders.Aliases;
import org.gcube.datatransformation.harvester.elasticsearch.loaders.TitleSnippet;
import org.gcube.datatransformation.harvester.elasticsearch.loaders.Transformers;
import org.gcube.datatransformation.harvester.elasticsearch.tools.DomTool;
import org.gcube.rest.index.client.ClientFactory;
import org.gcube.rest.index.client.cache.IndexClient;
import org.gcube.rest.index.client.exceptions.BadCallException;
import org.gcube.rest.index.client.exceptions.NoAvailableIndexServiceInstance;
import org.gcube.rest.index.common.entities.CollectionInfo;
import org.gcube.rest.index.common.entities.configuration.DatasourceType;
import org.gcube.rest.index.common.entities.fields.config.FacetType;
import org.gcube.rest.index.common.entities.fields.config.FieldConfig;
import org.json.JSONObject;
import org.w3c.dom.Node;

public class ElasticSearchManager
implements ManagerOfHarvested {
    private static Object LOCK = new Object();
    private static final String SCHEMA_ALIAS_FOLDER = "schema_alias/";
    private static final Logger logger = Logger.getLogger(ElasticSearchManager.class);
    private static ElasticSearchManager elasticSearchManager = null;
    private IndexClient indexClient = null;
    public static int PRETTY_PRINT_INDENT_FACTOR = 1;

    protected ElasticSearchManager(String indexScope) {
        this.indexClient = ClientFactory.getMeAnIndexClient((String)indexScope);
    }

    public static ElasticSearchManager getElasticSearchManager(String indexScope) {
        if (elasticSearchManager == null) {
            elasticSearchManager = new ElasticSearchManager(indexScope);
        }
        return elasticSearchManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeHarvested(HarvestedInfoObject harvestedInfoObject) {
        if (harvestedInfoObject.getRetrievedNodes().getNodes().size() != 0) {
            logger.debug((Object)("(" + Thread.currentThread().getId() + ")  results to INSERT(" + harvestedInfoObject.getRetrievedNodes().getNodes().size() + ") to elastic --  uri(" + harvestedInfoObject.getUri() + ") metadataPrefix(" + harvestedInfoObject.getMetadataPrefix() + ")"));
        }
        if (harvestedInfoObject.getRetrievedNodes().getNodesToDelete().size() != 0) {
            logger.debug((Object)("(" + Thread.currentThread().getId() + ")  results to DELETE(" + harvestedInfoObject.getRetrievedNodes().getNodesToDelete().size() + ") to elastic --  uri: " + harvestedInfoObject.getUri() + ") metadataPrefix(" + harvestedInfoObject.getMetadataPrefix() + ")"));
        }
        if (harvestedInfoObject.getFirstTimeToStore().booleanValue()) {
            try {
                boolean result = this.preConfigure(harvestedInfoObject);
                if (result) {
                    logger.debug((Object)"Successfully preconfigured the new datasource in E.S. prior inserting the values");
                } else {
                    logger.debug((Object)"Failed to preconfigure the new datasource in E.S. prior inserting the values");
                }
            }
            catch (NoAvailableIndexServiceInstance na) {
                logger.debug((Object)"No available index service... cannot preconfigure the new datasource in E.S");
            }
            catch (BadCallException bc) {
                logger.debug((Object)"Bad call on index client... cannot preconfigure the new datasource in E.S");
            }
        }
        String jsonTransformer = Transformers.getAllTransformers().get(harvestedInfoObject.getMetadataPrefix());
        Set toDel = harvestedInfoObject.getRetrievedNodes().getNodesToDelete();
        Map idNodesPairs = harvestedInfoObject.getRetrievedNodes().getNodes();
        for (Map.Entry entry : idNodesPairs.entrySet()) {
            try {
                String nodeId = (String)entry.getKey();
                Node node = (Node)entry.getValue();
                DomTool.removeAttribsFromChildren(node);
                String nodeStr = DomTool.nodeToString(node);
                JSONObject xmlJSONObj = XML.toJSONObject(nodeStr);
                String jsonPrettyPrintString = xmlJSONObj.toString(PRETTY_PRINT_INDENT_FACTOR);
                if (jsonTransformer != null && !jsonTransformer.isEmpty()) {
                    Chainr chainr = Chainr.fromSpec((Object)JsonUtils.jsonToList((String)jsonTransformer));
                    jsonPrettyPrintString = JsonUtils.toJsonString((Object)chainr.transform(JsonUtils.jsonToObject((String)jsonPrettyPrintString)));
                }
                boolean status = false;
                Object object = LOCK;
                synchronized (object) {
                    status = this.indexClient.insertJson(harvestedInfoObject.getScope(), harvestedInfoObject.getCollectionID().toLowerCase(), nodeId, jsonPrettyPrintString);
                }
                if (status) continue;
                logger.debug((Object)("Could not insert a document into the index " + harvestedInfoObject.getCollectionID().toLowerCase()));
            }
            catch (TransformerException ex) {
                logger.error((Object)"Could not transform a harvested document for the index");
            }
            catch (NoAvailableIndexServiceInstance na) {
                logger.error((Object)"No other available index instances to serve. Please wait till the refresh (usually within a couple of minutes)");
            }
        }
        toDel.forEach(idToDel -> {
            try {
                boolean status = this.indexClient.delete(harvestedInfoObject.getCollectionID().toLowerCase(), idToDel);
                if (!status) {
                    logger.debug((Object)("STATUS:FALSE - Could not remove an OAI-PMH deleted document from the index " + harvestedInfoObject.getCollectionID().toLowerCase()));
                }
            }
            catch (Exception e) {
                logger.debug((Object)("EXCEPTION - Could not remove an OAI-PMH deleted document from the index " + harvestedInfoObject.getCollectionID().toLowerCase()));
            }
        });
    }

    public void deleteHarvested(Set<String> collectionIds) throws NoAvailableIndexServiceInstance {
    }

    public boolean preConfigure(HarvestedInfoObject harvestedInfoObject) throws NoAvailableIndexServiceInstance, BadCallException {
        List previous = this.indexClient.getCompleteCollectionInfo(harvestedInfoObject.getCollectionID(), harvestedInfoObject.getScope());
        if (previous != null && !previous.isEmpty() && ((CollectionInfo)previous.get(0)).getId().equals(harvestedInfoObject.getCollectionID())) {
            return true;
        }
        CollectionInfo collInfo = new CollectionInfo(harvestedInfoObject.getCollectionID(), harvestedInfoObject.getScope(), DatasourceType.ELASTIC, harvestedInfoObject.getUri(), "", new Date());
        Properties aliasProps = Aliases.getAllAliases().get(harvestedInfoObject.getMetadataPrefix());
        if (aliasProps != null) {
            HashMap<String, String> aliases = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : aliasProps.entrySet()) {
                aliases.put(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
            }
            collInfo.setCollectionFieldsAliases(aliases);
        } else {
            logger.warn((Object)("No field alias definitions by the name " + harvestedInfoObject.getMetadataPrefix() + ".properties found within the classpath."));
        }
        Properties titleSnippetProps = TitleSnippet.getAllTitleSnippets().get(harvestedInfoObject.getMetadataPrefix());
        if (titleSnippetProps != null) {
            HashMap<String, FieldConfig> fieldConfigs = collInfo.getCollectionFieldsConfigs();
            if (fieldConfigs == null) {
                fieldConfigs = new HashMap<String, FieldConfig>();
            }
            for (Map.Entry<Object, Object> entry : titleSnippetProps.entrySet()) {
                String entryStr = (String)entry.getKey();
                FieldConfig fieldConfig = (FieldConfig)fieldConfigs.get((String)entry.getValue());
                if (entryStr.trim().toLowerCase().equals("title")) {
                    if (fieldConfig == null) {
                        fieldConfigs.put((String)entry.getValue(), new FieldConfig(FacetType.NONE, true, null, true, false));
                    } else {
                        ((FieldConfig)fieldConfigs.get((String)entry.getValue())).setServesAsTitle(true);
                    }
                }
                if (!entryStr.trim().toLowerCase().equals("snippet")) continue;
                if (fieldConfig == null) {
                    fieldConfigs.put((String)entry.getValue(), new FieldConfig(FacetType.NONE, true, null, false, true));
                    continue;
                }
                ((FieldConfig)fieldConfigs.get((String)entry.getValue())).setServesAsSnippet(true);
            }
        } else {
            logger.warn((Object)("No title-snippet definitions by the name " + harvestedInfoObject.getMetadataPrefix() + ".properties found within the classpath."));
        }
        return this.indexClient.setCompleteCollectionInfo(collInfo);
    }
}

