/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.utils;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.utils.DataPublisherResponse;

public class RequestData {
    private static final Logger logger = Logger.getLogger(RequestData.class);

    public static DataPublisherResponse requestHarvest(String url, Map<String, String> parameters) throws Exception {
        System.out.println("URI: " + url + " -- resumptionToken: " + parameters.get("resumptionToken") + " -- metadataPrefix: " + parameters.get("metadataPrefix"));
        DataPublisherResponse dataPublisherResponse = new DataPublisherResponse();
        Client client = Client.create();
        WebResource webResource = null;
        MultivaluedMapImpl nameValuePairs = new MultivaluedMapImpl();
        for (Map.Entry<String, String> params : parameters.entrySet()) {
            if (params.getKey() == null || params.getKey().isEmpty() || params.getValue() == null || params.getValue().isEmpty()) continue;
            nameValuePairs.add((Object)params.getKey(), (Object)params.getValue());
        }
        webResource = client.resource(url).queryParams((MultivaluedMap)nameValuePairs);
        ClientResponse response = null;
        try {
            response = (ClientResponse)webResource.get(ClientResponse.class);
        }
        catch (Exception e) {
            dataPublisherResponse.setErrorCode(-2);
            return dataPublisherResponse;
        }
        if (response.getStatus() != 201 && response.getStatus() != 200) {
            logger.info((Object)("Failed : HTTP error code : " + response.getStatus()));
            if (response.getStatus() == 301) {
                ArrayList<String> locationsReturned = new ArrayList<String>();
                List locations = (List)response.getHeaders().get((Object)"Location");
                if (locations != null && !locations.isEmpty()) {
                    for (String loc : locations) {
                        locationsReturned.add(loc.split("\\?")[0]);
                    }
                }
                return new DataPublisherResponse(locationsReturned, 301, "Redirect to another data publisher");
            }
            if (response.getStatus() == 500) {
                dataPublisherResponse.setErrorCode(500);
                dataPublisherResponse.setErrorMessage("The server encountered an unexpected condition which prevented it from fulfilling the request");
            } else if (response.getStatus() == 503) {
                int retryAfter;
                if (response.getHeaders().get((Object)"Retry-After") != null && (retryAfter = Integer.parseInt((String)((List)response.getHeaders().get((Object)"Retry-After")).get(0))) != 0) {
                    dataPublisherResponse.setRetryAfter(retryAfter);
                }
                dataPublisherResponse.setErrorCode(503);
                dataPublisherResponse.setErrorMessage("The server will be alleviated after some delay.");
                logger.error((Object)response.toString());
            } else {
                dataPublisherResponse.setErrorCode(response.getStatus());
                dataPublisherResponse.setErrorMessage(response.toString());
            }
        }
        dataPublisherResponse.setBody((String)response.getEntity(String.class));
        return dataPublisherResponse;
    }
}

