<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html>
	<head>
		<title>Harvester</title>
		<meta charset="UTF-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<link href='//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=latin,greek-ext' rel='stylesheet' type='text/css'>
	
		<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/css/jquery.dataTables.min.css" />
		<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/css/bootstrap-2.3.2.css" />
<%-- 		<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/css/bootstrap-2.3.2.min.css" /> --%>
<%-- 		<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/css/bootstrap-responsive-2.3.2.css" /> --%>
<%-- 		<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/css/bootstrap-responsive-2.3.2.min.css" /> --%>
		<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/css/dataTables.bootstrap.css" />
<%-- 		<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/css/dataTables.responsive.css" /> --%>
<%-- 		<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/css/dataTables.tableTools.min.css" /> --%>
		<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/css/bootstrap-combined.min.css" />
		<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/resources/css/harvester.css" />
	
	
	
		<script src="<%=request.getContextPath()%>/resources/script/jquery-1.12.0.min.js"></script>
		<script src="<%=request.getContextPath()%>/resources/script/jquery-ui-1.10.3.min.js"></script>
		<script src="<%=request.getContextPath()%>/resources/script/jquery.dataTables.js"></script>
		<script src="<%=request.getContextPath()%>/resources/script/jquery.dataTables.min.js"></script>
		<script src="<%=request.getContextPath()%>/resources/script/bootstrap-2.3.2.js"></script>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/bootstrap-2.3.2.min.js"></script> --%>
		<script src="<%=request.getContextPath()%>/resources/script/dataTables.bootstrap.js"></script>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/dataTables.responsive.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/dataTables.responsive.min.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/dataTables.tableTools.min.js"></script> --%>

		<script src='<%=request.getContextPath()%>/resources/script/harvester.js'></script>
		<script src='<%=request.getContextPath()%>/resources/script/harvester.commons.js'></script>
		<script src='<%=request.getContextPath()%>/resources/script/harvester.widget.notification.js'></script>
		<script src='<%=request.getContextPath()%>/resources/script/harvester.clearall.js'></script>

<%-- 		<script src="<%=request.getContextPath()%>/resources/script/jquery.mousewheel.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/jquery.jscrollpane.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/jquery.spinner.min.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/jquery.validate.min.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/jquery.ba-throttle-debounce.min.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/flat-ui-tagsinput.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/flat-ui-radiocheck.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/jquery.ba-throttle-debounce.min.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/ChartTooltip.js"></script> --%>
<%-- 		<script src="<%=request.getContextPath()%>/resources/script/bootstrap.min.js" > </script> --%>

		<script defer="defer" type="text/javascript">
			(function() {
		    	$(document).ready(function () {
		    		var renderURL = '%7Burl%7D?%7Bparams%7D';
		    		var resourceURL = '%7Burl%7D?%7Bparams%7D';
					var contextPath = '';
				
					window.Harvester.init(renderURL, resourceURL);
				});
			}());
		</script>
	</head>
	
	<body>
<!-- container for fixed size and container-fluid for full width-->
		<div class="container-fluid harvester">
			
			<div class="header-top row">
				<div id="headerTitleCon" class="harvesterHome">
					<h1 class="headerTitle"></h1>
				</div>
			</div>
		
			<div class="harvesterHome">
				<div>
					<div id="notificationContainer">
<!-- 						<div id="notification" > -->
<!-- 						<div id="notification" aria-hidden="true"> -->
<!-- 						</div> -->
					</div>
					<button type="button" id="newServiceButton" data-target="#addNewServiceModal" data-toggle="modal">
						<span class="createNewIcon"></span>
						<span class="msg">Add new service</span>
					</button>
				</div>
				
				<div class="row-fluid giveMeSomeMargin">
					<div class="span8  results_wrapper" id="endPointsTableDiv" style="padding-left: 0">
						<table id="endPointsTable" class="hover order-column" cellspacing="0" >
							<thead>
            					<tr>
					                <th width="25%" class="nameHeader">Name<div class="giveMeSomeSpace"></div>
					                	<hr/>
					                </th>
					                <th width="25%" class="statusHeader">Status<div class="giveMeSomeSpace"></div>
					                	<hr/>
					                </th>
					                <th width="25%" class="numberOfRecordsHeader">Number of records<div class="giveMeSomeSpace"></div>
					                	<hr/>
					                </th>
					                <th width="25%" class="intervalHeader">Every<div class="giveMeSomeSpace"></div>
					                	<hr/>
					                </th>
					                <th width="25%" class="lastHarvestHeader">Last Harvest<div class="giveMeSomeSpace"></div>
					                	<hr/>
					                </th>
					                <th width="25%" class="actionsHeader">Actions<div class="giveMeSomeSpace"></div>
					                	<hr/>
					                </th>
					                <th width="25%" class="arrowHeader"><div class="giveMeSomeSpace"></div>
					                	
					                </th>
					            </tr>
					        </thead>
        					<tbody>					            
        					</tbody>
						</table>
					</div>
					
					<div class="span4 results_wrapper" id="harvestedInfoTableDiv" style="padding-left: 0">
						<table id="harvestedInfoTable" class="hover order-column" cellspacing="0" >
							<thead>
            					<tr>
					                <th width="20%">Harvested Info
					                	<hr class="horLineInfo"/>
					                </th>
					            </tr>
							</thead>
        					<tbody>
					            <tr>
					                <td> 
					                	<div id="insideDownHere" style="padding-left: 0;">
					                		<p><i class="noItemSelected">select a service from the list</i>
					                		</p>
					                	</div>
					                	
										<div class="results_wrapper hideMe" id="infoOfEndPointsTableDiv" style="padding-left: 0" >
											<div class="repoName"></div>
											<table id="infoOfEndPointsTable" class="table borderless" >
												<tbody>
													<tr>
														<td class="boldLetters">Uri</td>
														<td class="uriOnInfo"></td>
													</tr>
													<tr>
														<td class="boldLetters">Schema</td>
														<td class="schemaOnInfo"></td>
													</tr>
												</tbody>
											</table>
											<table id="buttons" class="table borderless" >
												<tbody>
													<tr>
														<td>
																<button type="button" class="reHarvestNowButton" data-target="#reharvestEndPointModal" data-toggle="modal">
																	<span class="reharvestIcon"></span>
																	<span class="msg">Re-Harvest now</span>
																</button>
														</td>
														<td>
																<button type="button" class="editHarvestButton" data-target="#editEndPointModal"  data-toggle="modal">
																	<span class="editIcon"></span>
																	<span class="msg">Edit Harvest Info</span>
																</button>
														</td>
														<td>
																<button type="button" class="removeHarvestButton" data-target="#removeEndPointModal"  data-toggle="modal">
																	<span class="removeIcon"></span>
																	<span class="msg">Remove Service</span>
																</button>
														</td>
													</tr>
												</tbody>
											</table>
										</div>
					                	
					                </td>
					            </tr>
        					</tbody>
						</table>
					</div>
					
				</div>

			</div>
			
			
			
			
			
<!-- 			<div class="triangleContainer"> -->
<!-- 				<div class="triangleVertical"> -->
<!-- 					<div class="empty"></div> -->
<!-- 				</div> -->
<!-- 				<div class="arrowLineVertical"></div> -->
<!-- 			</div> -->
			
			
			
			
			
<!-- 			<div class="row pageFooter"> -->
<!-- 				<div class="launcher"> -->
<!-- 					<h1>  -->
<!-- 						Launched by  <a href="http://www.cite.gr">CITE S.A.</a> -->
<!-- 					</h1> -->
<!-- 				</div> -->
<!-- 			</div> -->
			
			
			
			
<!-- 	---------------------------------------------------------------MODALS-------------------------------------------------------------------------------------	 -->
	
		<!-- 	add new end point for harvesting -->
			<div id="addNewServiceModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="addNewServiceModalLabel" aria-hidden="true">
				<div>
					<div class="header-top row">
						<div class="headerOfModal">
							<h1 class="titleOfModal">Add new service</h1>
						</div>
					</div>
				
					<div class="registrationContainerModal">
						<table class="table borderless" id="registrationTable">
							<tbody>
								<tr>
							        <td class="boldLetters">Uri</td>
							        <td>
							        	<input class="modalUri" type="text" placeholder="Type uri">
							        	<div id="requiredFieldContainer">
							        		<span id="requiredField">This field has not an appropriate value</span>
							        	</div>
							        </td>
							    </tr>
							    <tr>
							        <td class="boldLetters">Schema</td>
							        <td>
							        	<ul class="chooseSchema">
							        		<li>
											    <input type="radio" id="schemaDC" name="rOpt" value="dc" checked>
											    <label for="schemaDC">Default Schema (oai_dc)</label>
											    <div class="check"></div>
											</li>
							        		<li>
											    <input type="radio" id="schemasAll" name="rOpt" value="all">
											    <label for="schemasAll">All schemas</label>
											    <div class="check"></div>
											</li>
							        	</ul>
							 		</td>
							      </tr>  		
							    <tr>
							        <td class="boldLetters">
							        	<p>Interval Time</p>
							        	<div class="noteIntTime">*interval time is optional. A default is used in case is not set</div>
							        </td>
							        <td>
							        	<div class="btn-group">
							        		<input  class="intervalT" type="text" placeholder="Type time">
										    <button class="btn dropdown-toggle timeUnitDD" data-toggle="dropdown">
										    	Days
										    	<span class="caret"></span>
										    </button>
										    <ul class="dropdown-menu dropdown-menu-right timeUnitList">
										    	<li>Days</li>
												<li>Hours</li>
										    	<li>Minutes</li>
										    </ul>
    									</div>
    									<div id="timeUnitFieldContainer">
							        		<span id="timeUnitField"></span>
							        	</div>	
							        </td>
							    </tr>
							</tbody>
						</table>
					</div>
					<div class="footerOfModal">
						<table class="table borderless">
							<tbody>
								<tr>
									<td>
										<button class="saveModal createNewEndPoint">Save</button>
										<button class="cancelModal" data-dismiss="modal">Cancel</button>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
				
				
		<!-- 	remove end point -->
			<div id="removeEndPointModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="removeEndPointModalLabel" aria-hidden="true">
				<div>
					<div class="header-top row">
						<div class="headerOfModal">
							<h1 class="titleOfModal">Confirm Delete</h1>
						</div>
					</div>
				
					<div class="registrationContainerModal">
						<p>You are about to delete end point: </p>
						<p>
						<span id="uriToDelete">
						</span>
						</p>
						<p>Do you want to proceed?</p>
					</div>
				
					<div class="footerOfModal">
						<table class="table borderless">
							<tbody>
								<tr>
									<td>
										<button class="deleteModal" id="deleteUriModal">Delete</button>
										<button class="cancelModal" data-dismiss="modal">Cancel</button>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
				
				
		<!-- 	edit end point -->
			<div id="editEndPointModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="editEndPointModalLabel" aria-hidden="true">
				<div>
					<div class="header-top row">
						<div class="headerOfModal">
							<h1 class="titleOfModal">Confirm Edit</h1>
						</div>
					</div>
				
					<div class="registrationContainerModal">
						<table class="table borderless" id="registrationTable">
							<tbody>
								<tr>
							        <td class="boldLetters">Uri</td>
							        <td>
							        	<span id="uriEditModal"></span>
							        </td>
							    </tr>
							    <tr>
							        <td class="boldLetters">Schema</td>
							         <td>
<!-- 							        	<input id="schemaEditModal" type="text" placeholder="Type uri" readonly> -->
							        	<span id="schemaEditModal"></span>
							        </td>
							    </tr>    
							    <tr>
							        <td class="boldLetters">
							        	<p>Interval Time</p>
							        	<div class="noteIntTime">*interval time is optional. A default is used in case is not set</div>
							        </td>
							        <td>
							        	<div class="btn-group">
							        		<input  class="intervalT" type="text" placeholder="Type time">
										    <button class="btn dropdown-toggle timeUnitDD" data-toggle="dropdown">
										    	Days
										    	<span class="caret"></span>
										    </button>
										    <ul class="dropdown-menu dropdown-menu-right" id="editTimeUnitModal">
										    	<li id="days">Days</li>
												<li id="hours">Hours</li>
										    	<li id="minutes">Minutes</li>
										    </ul>
    									</div>	
							        </td>
							    </tr>
							    <tr class="defaultTimeDiv">
							        <td class="boldLetters">
							        	<p>Default Time</p>
							        </td>
							        <td>
							        	<div class="btn-group">
							        		<input  class="intervalDefT" type="text" placeholder="Type time">
										    <button class="btn dropdown-toggle timeUnitDefTime" data-toggle="dropdown">
										    	Days
										    	<span class="caret"></span>
										    </button>
										    <ul class="dropdown-menu dropdown-menu-right" id="editTimeUnitModalDefTime">
										    	<li id="days">Days</li>
												<li id="hours">Hours</li>
										    	<li id="minutes">Minutes</li>
										    </ul>
    									</div>	
							        </td>
							    </tr>
							    
							</tbody>
						</table>
					</div>
		
					<div class="footerOfModal">
						<table class="table borderless">
							<tbody>
								<tr>
									<td>
										<button class="saveModal" id="saveEditModal">Save</button>
										<button class="cancelModal" data-dismiss="modal">Cancel</button>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			
		<!-- 	reharvest end point -->
			<div id="reharvestEndPointModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="reharvestEndPointModalLabel" aria-hidden="true">
				<div>
					<div class="header-top row">
						<div class="headerOfModal">
							<h1 class="titleOfModal">Confirm re-Harvesting</h1>
						</div>
					</div>
				
					<div class="registrationContainerModal">
						<p>You are about to start harvesting of end point  </p>
						<p>
						<span id="uriToReharvest">
						</span>	
						</p>
					</div>
				
					<div class="footerOfModal">
						<table class="table borderless">
							<tbody>
								<tr>
									<td>
										<button class="proceedModal" id="reharvestProceedModal">Harvest</button>
										<button class="cancelModal" data-dismiss="modal">Cancel</button>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			
			<div class="loaderContainer">
				<div class="loader">
					<img alt="" src="<%=request.getContextPath()%>/resources/images/loading.gif" />
				</div>
			</div>
			
		</div>
		
	</body>
</html>