/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.filesmanagement.archive;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.core.MessageForEveryDataProvider;
import org.gcube.datatransformation.harvester.filesmanagement.archive.RegisteredRequests;
import org.gcube.datatransformation.harvester.filesmanagement.manager.FilesManagerRead;
import org.gcube.datatransformation.harvester.utils.GetProperties;

public class ReadUrls
implements FilesManagerRead {
    private static final Logger logger = Logger.getLogger(ReadUrls.class);

    public void readFromFile(boolean initialization) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            File file = new File(GetProperties.getPropertiesInstance().getArchivesFile());
            if (file != null && file.canRead() && file.length() != 0L) {
                List<Object> messages = Arrays.asList((Object[])objectMapper.readValue(file, MessageForEveryDataProvider[].class));
                RegisteredRequests.getRegisteredRequestsInstance().getRegisteredRequestsMapping().clear();
                for (MessageForEveryDataProvider messageForEveryDataProvider : messages) {
                    if (initialization && messageForEveryDataProvider.isExecuting().booleanValue()) {
                        messageForEveryDataProvider.setExecuting(Boolean.valueOf(false));
                    }
                    RegisteredRequests.getRegisteredRequestsInstance().setInRequestsMapping(messageForEveryDataProvider.getInfoForHarvesting().getUrl(), messageForEveryDataProvider);
                }
            }
        }
        catch (IOException e) {
            logger.info((Object)e.getMessage());
        }
    }
}

