/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.utils.retrieveinfo;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.core.db.RetrievedNodes;
import org.gcube.datatransformation.harvester.utils.retrieveinfo.RetrieveInfoByVerb;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class RetrieveInfoByVerb {
    private static final Logger logger = Logger.getLogger(RetrieveInfoByVerb.class);

    public static RetrievedNodes getNodes(String xml) throws ParseException {
        NodeList nodes = RetrieveInfoByVerb.retrieveNodes((String)xml);
        RetrievedNodes retrievedNodes = new RetrievedNodes();
        if (nodes != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (nodes.item(i).getNodeType() != 1) continue;
                Node header = ((Element)nodes.item(i)).getElementsByTagName("header").item(0);
                Element element = (Element)header;
                if (element.getAttribute("status") != null && !element.getAttribute("status").isEmpty()) {
                    retrievedNodes.addToNodesToDelete(((Element)header).getElementsByTagName("identifier").item(0).getTextContent());
                    continue;
                }
                retrievedNodes.addToNodes(((Element)header).getElementsByTagName("identifier").item(0).getTextContent(), nodes.item(i));
            }
        }
        return retrievedNodes;
    }

    public static NodeList retrieveNodes(String xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Object builder = null;
        NodeList nodes = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document document = db.parse(is);
            XPath xPath = XPathFactory.newInstance().newXPath();
            nodes = (NodeList)xPath.compile("/OAI-PMH/ListRecords/record").evaluate(document, XPathConstants.NODESET);
        }
        catch (NullPointerException e) {
            logger.info((Object)e.getMessage());
        }
        catch (ParserConfigurationException e) {
            logger.info((Object)e.getMessage());
        }
        catch (XPathExpressionException e) {
            logger.info((Object)e.getMessage());
        }
        catch (SAXException e) {
            logger.info((Object)e.getMessage());
        }
        catch (IOException e) {
            logger.info((Object)e.getMessage());
        }
        return nodes;
    }

    private static NodeList getNodesOfListRecords(String xmlFile) throws ParseException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        NodeList nodes = null;
        try {
            builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xmlFile));
            Document document = builder.parse(is);
            XPath xPath = XPathFactory.newInstance().newXPath();
            nodes = (NodeList)xPath.compile(RetrieveInfoByVerb.getInfo((String)"ListRecords")).evaluate(document, XPathConstants.NODESET);
        }
        catch (NullPointerException e) {
            logger.info((Object)e.getMessage());
        }
        catch (ParserConfigurationException e) {
            logger.info((Object)e.getMessage());
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            logger.info((Object)e.getMessage());
        }
        catch (IOException e) {
            logger.info((Object)e.getMessage());
        }
        return nodes;
    }

    public static boolean getNodesFromBeforeLeastDate(String xmlFile, Date beforeLeastRecentlyDate) throws ParseException {
        NodeList nodes = RetrieveInfoByVerb.getNodesOfListRecords((String)xmlFile);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Node header = ((Element)node).getElementsByTagName("header").item(0);
            String datestamp = ((Element)header).getElementsByTagName("datestamp").item(0).getTextContent();
            Date date = DatatypeConverter.parseDateTime((String)datestamp).getTime();
            if (!date.equals(beforeLeastRecentlyDate) && !date.before(beforeLeastRecentlyDate)) continue;
            return false;
        }
        return true;
    }

    private static String createNewXML(Node node) {
        Document newDocument = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            newDocument = builder.newDocument();
            Node importedNode = newDocument.importNode(node, true);
            newDocument.appendChild(importedNode);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (newDocument != null) {
            return RetrieveInfoByVerb.printXmlDocument(newDocument);
        }
        return null;
    }

    private static String getVerb() {
        return "/OAI-PMH/request/@verb";
    }

    private static String getInfo(String verb) {
        if (verb.equals("ListRecords")) {
            return "/OAI-PMH/" + verb + "/record";
        }
        if (verb.equals("ListSets")) {
            return "/OAI-PMH/" + verb + "/set";
        }
        if (verb.equals("ListMetadataFormats")) {
            return "/OAI-PMH/" + verb + "/metadataFormat";
        }
        if (verb.equals("ListIdentifiers")) {
            return "/OAI-PMH/" + verb + "/header";
        }
        if (verb.equals("Identify")) {
            return "/OAI-PMH/" + verb;
        }
        if (verb.equals("GetRecord")) {
            return "/OAI-PMH/" + verb;
        }
        return null;
    }

    public static String createNewXML(String verb, List<NodeList> listNodeLists, List<Node> listNodes) {
        Document newXML = null;
        try {
            newXML = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = newXML.createElement(verb);
            newXML.appendChild(root);
            for (NodeList nodes : listNodeLists) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    Node copyNode = newXML.importNode(node, true);
                    root.appendChild(copyNode);
                    listNodes.add(node);
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        if (newXML != null) {
            return RetrieveInfoByVerb.printXmlDocument((Document)newXML);
        }
        return null;
    }

    private static LeastDates getLeastRecentlyDate(List<NodeList> listNodes) throws ParseException {
        LeastDates ld = new LeastDates();
        for (NodeList nodes : listNodes) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                Node header = ((Element)node).getElementsByTagName("header").item(0);
                String datestamp = ((Element)header).getElementsByTagName("datestamp").item(0).getTextContent();
                Date date = DatatypeConverter.parseDateTime((String)datestamp).getTime();
                if (ld.getLeastRecentlyDate() != null) {
                    if (!ld.getLeastRecentlyDate().before(date)) continue;
                    ld.setBeforeLeastRecentlyDate(ld.getLeastRecentlyDate());
                    ld.setLeastRecentlyDate(date);
                    continue;
                }
                ld.setBeforeLeastRecentlyDate(ld.getLeastRecentlyDate());
                ld.setLeastRecentlyDate(date);
            }
        }
        if (ld.getBeforeLeastRecentlyDate() == null) {
            ld.setBeforeLeastRecentlyDate(ld.getLeastRecentlyDate());
        }
        return ld;
    }

    public static String printXmlDocument(Document document) {
        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
        LSOutput lsOutput = domImplementationLS.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        lsOutput.setCharacterStream(stringWriter);
        lsSerializer.write(document, lsOutput);
        String string = ((Object)stringWriter).toString();
        return string;
    }
}

