/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.filesmanagement.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.datatransformation.harvester.core.MessageForEveryDataProvider;
import org.gcube.datatransformation.harvester.filesmanagement.archive.WriteUrls;
import org.gcube.datatransformation.harvester.filesmanagement.manager.FilesManagerWrite;
import org.gcube.datatransformation.harvester.filesmanagement.manager.RWActions;
import org.gcube.datatransformation.harvester.harvestedmanagement.core.SelectedDatabase;

public class RegisteredRequests {
    private static RegisteredRequests registeredRequests = null;
    private Map<String, List<MessageForEveryDataProvider>> registeredRequestsMapping = Collections.synchronizedMap(new HashMap());

    protected RegisteredRequests() {
    }

    public static RegisteredRequests getRegisteredRequestsInstance() {
        if (registeredRequests == null) {
            registeredRequests = new RegisteredRequests();
        }
        return registeredRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatusMessagesForUrl(MessageForEveryDataProvider message, Boolean isExecuting) {
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                List messages = (List)this.registeredRequestsMapping.get(message.getInfoForHarvesting().getUrl());
                if (messages == null) {
                    messages = new /* Unavailable Anonymous Inner Class!! */;
                } else {
                    MessageForEveryDataProvider toUpdate = null;
                    for (MessageForEveryDataProvider m : messages) {
                        if (!m.getInfoForHarvesting().getUrl().equals(message.getInfoForHarvesting().getUrl()) || !m.getInfoForHarvesting().getListRecords().getMetadataPrefix().equals(message.getInfoForHarvesting().getListRecords().getMetadataPrefix()) || !m.getScope().equals(message.getScope())) continue;
                        toUpdate = m;
                        break;
                    }
                    if (isExecuting.booleanValue()) {
                        if (toUpdate.isExecuting().booleanValue()) {
                            return false;
                        }
                        toUpdate.setForceReharvest(false);
                    }
                    messages.remove(toUpdate);
                    toUpdate.setExecuting(isExecuting);
                    messages.add(toUpdate);
                }
                this.registeredRequestsMapping.put(message.getInfoForHarvesting().getUrl(), messages);
                RWActions.writeToFile((FilesManagerWrite)WriteUrls.getWriteUrlsInstance());
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatusMessagesForUrl(String url, Boolean isExecuting, String scope) {
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                List messages = (List)this.registeredRequestsMapping.get(url);
                if (messages == null) {
                    return;
                }
                MessageForEveryDataProvider mm = null;
                for (MessageForEveryDataProvider m : messages) {
                    if (!m.getScope().equals(scope)) continue;
                    mm = m;
                    break;
                }
                messages.remove(mm);
                mm.setExecuting(isExecuting);
                messages.add(mm);
                this.registeredRequestsMapping.put(url, messages);
                RWActions.writeToFile((FilesManagerWrite)WriteUrls.getWriteUrlsInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageForEveryDataProvider> getFromRegisteredRequestsMapping(String key) {
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                if (this.registeredRequestsMapping.get(key) == null) {
                    return null;
                }
                ArrayList<MessageForEveryDataProvider> messages = new ArrayList<MessageForEveryDataProvider>();
                messages.addAll((Collection)this.registeredRequestsMapping.get(key));
                return messages;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToDeleteFalse(String url) {
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                List messages = (List)this.registeredRequestsMapping.get(url);
                if (messages == null) {
                    return;
                }
                for (MessageForEveryDataProvider m : messages) {
                    m.setToDelete(Boolean.valueOf(false));
                }
                this.registeredRequestsMapping.put(url, messages);
                RWActions.writeToFile((FilesManagerWrite)WriteUrls.getWriteUrlsInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkExistence(String url, String supportedSchema, String scope) {
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                List messages = (List)this.registeredRequestsMapping.get(url);
                for (MessageForEveryDataProvider message : messages) {
                    if ((!message.getSchemaSupportedForUrl().equals(supportedSchema) || !message.getScope().equals(scope)) && (!message.getSchemaSupportedForUrl().equals("all") || !supportedSchema.equals("dc") || !message.getScope().equals(scope))) continue;
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reharvestUri(String uri, String metadataPrefix, String scope) {
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                MessageForEveryDataProvider mm = null;
                List messages = (List)this.registeredRequestsMapping.get(uri);
                for (MessageForEveryDataProvider m : messages) {
                    if (!scope.equals(m.getScope()) || !m.getInfoForHarvesting().getListRecords().getMetadataPrefix().equals(metadataPrefix)) continue;
                    if (m.isExecuting().booleanValue()) {
                        return false;
                    }
                    mm = m;
                    break;
                }
                if (mm != null) {
                    messages.remove(mm);
                    mm.setForceReharvest(true);
                    messages.add(mm);
                    this.registeredRequestsMapping.put(uri, messages);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<MessageForEveryDataProvider>> getRegisteredRequestsMapping() {
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                return new HashMap<String, List<MessageForEveryDataProvider>>(this.registeredRequestsMapping);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageForEveryDataProvider> getAllMessages() {
        ArrayList<MessageForEveryDataProvider> messagesForEveryDataProviders = new ArrayList<MessageForEveryDataProvider>();
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                for (Map.Entry entry : this.registeredRequestsMapping.entrySet()) {
                    for (MessageForEveryDataProvider m : (List)entry.getValue()) {
                        messagesForEveryDataProviders.add(m);
                    }
                }
            }
        }
        return messagesForEveryDataProviders;
    }

    public boolean removeFromRegisteredRequests(MessageForEveryDataProvider m) {
        return this.removeFromRegisteredRequests(m.getInfoForHarvesting().getUrl(), m.getScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromRegisteredRequests(String uri, String scope) {
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                ArrayList<MessageForEveryDataProvider> messages = new ArrayList<MessageForEveryDataProvider>();
                List fetched = (List)this.registeredRequestsMapping.get(uri);
                if (fetched == null || fetched.isEmpty()) {
                    return false;
                }
                for (MessageForEveryDataProvider m : fetched) {
                    MessageForEveryDataProvider mNew = new MessageForEveryDataProvider();
                    mNew = m;
                    if (!m.getScope().equals(scope)) {
                        messages.add(mNew);
                        continue;
                    }
                    mNew.setToDelete(Boolean.valueOf(true));
                    mNew.setSizeOfList(0);
                    mNew.setStatus(null);
                    mNew.setStatusMessage("");
                    mNew.setLastHarvestingTime(null);
                    messages.add(mNew);
                }
                this.registeredRequestsMapping.put(uri, messages);
                RWActions.writeToFile((FilesManagerWrite)WriteUrls.getWriteUrlsInstance());
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hardRremoveFromRegisteredRequests(Map<String, Set<String>> urisToDelete) {
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                HashSet<String> collectionIdsToDelete = new HashSet<String>();
                ArrayList<MessageForEveryDataProvider> toKeepMessages = new ArrayList<MessageForEveryDataProvider>();
                for (Map.Entry<String, Set<String>> recordToDelete : urisToDelete.entrySet()) {
                    Set<String> urlsToDel = recordToDelete.getValue();
                    for (String url : urlsToDel) {
                        List mToDel = (List)this.registeredRequestsMapping.get(url);
                        for (MessageForEveryDataProvider mm : mToDel) {
                            if (mm.getScope().equals(recordToDelete.getKey())) {
                                collectionIdsToDelete.add(mm.getCollectionID());
                                continue;
                            }
                            toKeepMessages.add(mm);
                        }
                        this.registeredRequestsMapping.put(url, toKeepMessages);
                    }
                }
                RWActions.writeToFile((FilesManagerWrite)WriteUrls.getWriteUrlsInstance());
                SelectedDatabase.getSelectedDatabaseInstance().removeFromDB(collectionIdsToDelete);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInRequestsMapping(String key, MessageForEveryDataProvider value) {
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            Map map = this.registeredRequestsMapping;
            synchronized (map) {
                ArrayList<MessageForEveryDataProvider> list = (ArrayList<MessageForEveryDataProvider>)this.registeredRequestsMapping.get(key);
                if (list == null) {
                    list = new ArrayList<MessageForEveryDataProvider>();
                }
                if (!list.isEmpty() && this.checkExistence(list, value)) {
                    return;
                }
                list.add(value);
                this.registeredRequestsMapping.put(key, list);
                RWActions.writeToFile((FilesManagerWrite)WriteUrls.getWriteUrlsInstance());
            }
        }
    }

    private boolean checkExistence(List<MessageForEveryDataProvider> list, MessageForEveryDataProvider value) {
        for (MessageForEveryDataProvider m : list) {
            if (m.getInfoForHarvesting().getListRecords() == null || m.getInfoForHarvesting().getListRecords().getMetadataPrefix() == null || value.getInfoForHarvesting().getListRecords() == null || value.getInfoForHarvesting().getListRecords().getMetadataPrefix() == null || !m.getInfoForHarvesting().getListRecords().getMetadataPrefix().equals(value.getInfoForHarvesting().getListRecords().getMetadataPrefix())) continue;
            if (m.getToDelete().booleanValue()) {
                m.setToDelete(Boolean.valueOf(false));
            }
            return true;
        }
        return false;
    }
}

