/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class GetProperties {
    private static GetProperties instance = null;
    private String serviceUrlJson = null;
    private String serviceUrlParameters = null;
    private String newServiceUrlParameters = null;
    private String deleteServiceUrlParameters = null;
    private String archivesFile = null;
    private String queuedFile = null;
    private String timesFile = null;
    private String defaultHarvestInterval;
    private String defaultHarvestIntervalUnit;
    private String timeForScheduler = null;
    private String timeUnitForScheduler = null;
    private String timesDir = null;
    private String defaultVerb = null;
    private String defaultMetadataPrefix = null;
    private String jdbcDriver = null;
    private String jdbcUrl = null;
    private String dbusername = null;
    private String dbpassword = null;
    private String classNameForDB = null;
    private String indexScope = null;
    private String mongodb = null;

    protected GetProperties() {
        this.getProperties();
    }

    public static GetProperties getPropertiesInstance() {
        if (instance == null) {
            instance = new GetProperties();
        }
        return instance;
    }

    public String getServiceUrlJson() {
        return this.serviceUrlJson;
    }

    public String getServiceUrlParameters() {
        return this.serviceUrlParameters;
    }

    public String getNewServiceUrlParameters() {
        return this.newServiceUrlParameters;
    }

    public String getDeleteServiceUrlParameters() {
        return this.deleteServiceUrlParameters;
    }

    public String getArchivesFile() {
        return this.archivesFile;
    }

    public String getQueuedFile() {
        return this.queuedFile;
    }

    public String getTimesFile() {
        return this.timesFile;
    }

    public String getDefaultHarvestInterval() {
        return this.defaultHarvestInterval;
    }

    public String getDefaultHarvestIntervalUnit() {
        return this.defaultHarvestIntervalUnit;
    }

    public String getTimeForScheduler() {
        return this.timeForScheduler;
    }

    public String getTimeUnitForScheduler() {
        return this.timeUnitForScheduler;
    }

    public String getTimesDir() {
        return this.timesDir;
    }

    public String getDefaultVerb() {
        return this.defaultVerb;
    }

    public String getDefaultMetadataPrefix() {
        return this.defaultMetadataPrefix;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDbusername() {
        return this.dbusername;
    }

    public String getDbpassword() {
        return this.dbpassword;
    }

    public String getClassNameForDB() {
        return this.classNameForDB;
    }

    public String getIndexScope() {
        return this.indexScope;
    }

    public String getMongodb() {
        return this.mongodb;
    }

    private void getProperties() {
        InputStream input = null;
        try {
            Properties prop = new Properties();
            input = GetProperties.class.getClassLoader().getResourceAsStream("harvester.properties");
            prop.load(input);
            this.serviceUrlJson = prop.getProperty("service_url_json");
            this.serviceUrlParameters = prop.getProperty("service_url_parameters");
            this.newServiceUrlParameters = prop.getProperty("new_service_url_parameters");
            this.deleteServiceUrlParameters = prop.getProperty("delete_service_url_parameters");
            this.archivesFile = prop.getProperty("archives");
            this.queuedFile = prop.getProperty("queued");
            this.timesFile = prop.getProperty("times");
            this.defaultHarvestInterval = prop.getProperty("defaultHarvestInterval", "90");
            this.defaultHarvestIntervalUnit = prop.getProperty("defaultHarvestIntervalUnit", "DAYS");
            this.timeForScheduler = prop.getProperty("time_for_scheduler");
            this.timeUnitForScheduler = prop.getProperty("time_unit_for_scheduler");
            this.timesDir = prop.getProperty("times_dir");
            this.defaultVerb = prop.getProperty("default_verb");
            this.defaultMetadataPrefix = prop.getProperty("default_metadataPrefix");
            this.jdbcDriver = prop.getProperty("gr_cite_harvester_jdbc_driver");
            this.jdbcUrl = prop.getProperty("gr_cite_harvester_jdbc_url");
            this.dbusername = prop.getProperty("gr_cite_harvester_dbusername");
            this.dbpassword = prop.getProperty("gr_cite_harvester_dbpassword");
            this.classNameForDB = prop.getProperty("gr_cite_harvester_name_of_class_for_db");
            this.indexScope = prop.getProperty("gr_cite_elastic_search_indexscope");
            this.mongodb = prop.getProperty("gr_cite_harvester_mongodb");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

