/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.accounting.summary.access.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedList;
import org.gcube.data.access.accounting.summary.access.AccountingDao;
import org.gcube.data.access.accounting.summary.access.ParameterException;
import org.gcube.data.access.accounting.summary.access.impl.BasicConnectionManager;
import org.gcube.data.access.accounting.summary.access.impl.BasicContextTreeProvider;
import org.gcube.data.access.accounting.summary.access.impl.ConnectionManager;
import org.gcube.data.access.accounting.summary.access.impl.ContextTreeProvider;
import org.gcube.data.access.accounting.summary.access.impl.Queries;
import org.gcube.data.access.accounting.summary.access.model.Dimension;
import org.gcube.data.access.accounting.summary.access.model.MeasureResolution;
import org.gcube.data.access.accounting.summary.access.model.Record;
import org.gcube.data.access.accounting.summary.access.model.Report;
import org.gcube.data.access.accounting.summary.access.model.ReportElement;
import org.gcube.data.access.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.data.access.accounting.summary.access.model.Series;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingDaoImpl
implements AccountingDao {
    private static final Logger log = LoggerFactory.getLogger(AccountingDaoImpl.class);
    private ContextTreeProvider treeProvider = null;
    private ConnectionManager connectionManager = null;
    private static final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("yyyy-MM");

    public AccountingDaoImpl() {
        this.connectionManager = new BasicConnectionManager();
        this.treeProvider = new BasicContextTreeProvider();
    }

    public void setTreeProvider(ContextTreeProvider treeProvider) {
        this.treeProvider = treeProvider;
    }

    public AccountingDaoImpl(ContextTreeProvider treeProvider, ConnectionManager connectionManager) {
        this.treeProvider = treeProvider;
        this.connectionManager = connectionManager;
    }

    @Override
    public Report getReportByScope(ScopeDescriptor desc, Date from, Date to, MeasureResolution resolution) throws SQLException, ParameterException {
        DateTimeFormatter formatter = AccountingDaoImpl.getFormatter(resolution);
        LocalDateTime fromDate = from.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime toDate = to.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        long startReportTime = System.currentTimeMillis();
        log.info("Loading report {} for {} between {} and {} ", new Object[]{resolution, desc.getId(), formatter.format(fromDate), formatter.format(toDate)});
        Connection conn = this.connectionManager.getConnection();
        Queries queries = new Queries(conn);
        int timeSlices = AccountingDaoImpl.getRangeSize(from, to, resolution);
        ResultSet dimensionRS = queries.getAvailableDimensions(from, to, desc, resolution);
        LinkedList<Dimension> foundDimensions = new LinkedList<Dimension>();
        while (dimensionRS.next()) {
            String id = dimensionRS.getString("id");
            String label = dimensionRS.getString("label");
            String group = dimensionRS.getString("dimension_group");
            String aggregatedDim = dimensionRS.getString("aggregated_measure");
            foundDimensions.add(new Dimension(id, label, aggregatedDim, group));
        }
        log.debug("Found {} dimensions to load. ", (Object)foundDimensions.size());
        LinkedList<ReportElement> reports = new LinkedList<ReportElement>();
        for (Dimension entry : foundDimensions) {
            String xLabel = entry.getLabel();
            String yLabel = "time";
            String category = entry.getGroup();
            reports.add(new ReportElement(desc.getName() + " " + xLabel, category, xLabel, yLabel, new Series[]{this.getSeries(queries, from, to, entry, desc, resolution, timeSlices)}));
            if (!desc.hasChildren()) continue;
            LinkedList<Series> childrenSeries = new LinkedList<Series>();
            for (ScopeDescriptor child : desc.getChildren()) {
                childrenSeries.add(this.getSeries(queries, from, to, entry, child, resolution, timeSlices));
            }
            reports.add(new ReportElement(desc.getName() + " children " + xLabel, category, xLabel, yLabel, childrenSeries.toArray(new Series[childrenSeries.size()])));
        }
        log.info("Loaded {} report elements in {} ms", (Object)reports.size(), (Object)(System.currentTimeMillis() - startReportTime));
        return new Report(reports);
    }

    private Series getSeries(Queries queries, Date from, Date to, Dimension dim, ScopeDescriptor scope, MeasureResolution res, int timeSlices) throws SQLException {
        Record[] records = new Record[timeSlices];
        PreparedStatement ps = queries.prepareMeasuresByDimension(scope, res);
        DateTimeFormatter formatter = AccountingDaoImpl.getFormatter(res);
        LocalDateTime toSetStartDate = from.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        for (int i = 0; i < timeSlices; ++i) {
            toSetStartDate = AccountingDaoImpl.increment(toSetStartDate, res, i);
            LocalDateTime toSetEndDate = AccountingDaoImpl.increment(toSetStartDate, res, i + 1);
            ps.setLong(1, toSetStartDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            ps.setLong(2, toSetEndDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            ps.setString(3, dim.getId());
            ResultSet rs = ps.executeQuery();
            Record toSet = new Record(formatter.format(toSetStartDate), 0L);
            if (rs.next()) {
                toSet.setY(rs.getLong("measure"));
            }
            records[i] = toSet;
        }
        return new Series(scope.getName(), records);
    }

    private static LocalDateTime increment(LocalDateTime toIncrement, MeasureResolution res, int offset) {
        switch (res) {
            case MONTHLY: {
                return toIncrement.plusMonths(1L);
            }
        }
        throw new RuntimeException("Unexpected Resolution " + res);
    }

    private static DateTimeFormatter getFormatter(MeasureResolution res) {
        switch (res) {
            case MONTHLY: {
                return monthFormatter;
            }
        }
        throw new RuntimeException("Unexpected Resolution " + res);
    }

    @Override
    public ScopeDescriptor getTree(Object request) throws Exception {
        return this.treeProvider.getTree(request);
    }

    private static final int getRangeSize(Date from, Date to, MeasureResolution resolution) throws ParameterException {
        log.debug("Evaluating time range between {} , {} [{}]", new Object[]{from, to, resolution});
        Period p = Period.between(from.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), to.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        switch (resolution) {
            case MONTHLY: {
                return p.getMonths() + p.getYears() * 12;
            }
        }
        throw new ParameterException("Invalid resolution " + resolution);
    }
}

