/**
 * 
 */
package org.gcube.data.gml.constants;

/**
 * Represents all conventional label used in gdoc model.
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class Labels {
	
	/**Annotation property.*/
	final static public String ANNOTATION = "isAnnotatedBy";
	
	/**Alternative representation property.*/
	final static public String ALTERNATIVE ="hasAlternative";
	
	/**Part property.*/
	final static public String PART="isPartOf";
	
	/**Metadata property.*/
	final static public String METADATA="isDescribedBy";
	
	/**Content property.*/
	final static public String BYTESTREAM="bytestream";
	
	/**Content URL property.*/
	final static public String BYTESTREAM_URI="url";
	
	/**Name property.*/
	final static public String NAME="name";
	
	/**Last update property.*/
	final static public String LAST_UPDATE="lastUpdateTime";
	
	/**Content mime type property.*/
	final static public String MIME_TYPE ="mimeType";
	
	/**Content length property.*/
	final static public String LENGTH = "length";
	
	/**Creation time property.*/
	final static public String CREATION_TIME = "creationTime";
	
	/**Language property.*/
	final static public String LANGUAGE = "language";
	
	/**Schema URI property.*/
	final static public String SCHEMA_URI="schemaURI";
	
	/**Schema name property.*/
	final static public String SCHEMA_NAME="schemaName";

	/**Type property.*/
	final static public String TYPE="type";
	
	/** Previous annotation order property.*/
	final static public String PREVIOUS = "previous";
	
	/** Part order property.*/
	final static public String ORDER = "order";
	
	/**'Property' property.*/
	final static public String PROPERTY = "property";
	
	/**'Property Type' property.*/
	final static public String PROPERTY_TYPE="type";
	
	/**'Property' value property.*/
	final static public String PROPERTY_VALUE="value";
	
}
