/**
 * 
 */
package org.gcube.data.gml.elements;

import static org.gcube.data.tml.uri.URIs.*;

import java.net.URI;
import java.net.URISyntaxException;

import javax.xml.bind.annotation.XmlTransient;

/**
 * Partial implementation of {@link GCubeElement}s that occur within {@link GCubeDocument}s.
 * 
 * @author Fabio Simeoni (University of Strathclyde)
 *
 */
public abstract class BaseInnerElement extends BaseElement implements GCubeInnerElement {

	@XmlTransient
	private GCubeDocument document;
	
	BaseInnerElement() {} //for deserialisation and local additions
	
	BaseInnerElement(String id) {//supports staged updates
		super(id);
	}
	
	/**
	 * {@inheritDoc}
	 */
	public GCubeDocument document() {
		return document;
	}
	
	public void postBinding(GCubeDocument d) throws IllegalStateException, Exception {
		
		if (isNew())
			throw new IllegalStateException(this+" has no identifier");
		
		setDocument(d);
		

	}
	
	void setDocument(GCubeDocument d) throws IllegalArgumentException {
		if (document==null)
			document = d;
		else
			if (!d.equals(document))
				throw new IllegalArgumentException(this+"\n is already bound to \n"+document);
	}
	
	/**{@inheritDoc}*/
	public URI uri() throws IllegalStateException, URISyntaxException {
		
		if (isNew())
			throw new IllegalStateException("new element have no URI");
		
		if (document()==null)
			throw new IllegalStateException("elements that are not bound to documents do not have URIs");
		
		return make(rootId(document().uri()),sourceId(document().uri()),id());
	
	}
	
	
}
