/**
 * 
 */
package org.gcube.data.gml.elements;

import static org.gcube.data.gml.constants.Labels.*;
import static org.gcube.data.trees.io.Bindings.*;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

import org.gcube.data.trees.Constants;

/**
 * Defines a GCubeElement property.
 * @author Federico De Faveri defaveri@isti.cnr.it
 */
public class GCubeElementProperty {
	
	@XmlAttribute(name=ID_ATTR,namespace=Constants.TREE_NS)  
	private String key;
	
	@XmlElement(name=PROPERTY_TYPE) 
	private String type;
	
	@XmlElement(name=PROPERTY_VALUE) 
	private String value;

	/**
	 * Empty constructor necessary for serialisation.
	 */
	GCubeElementProperty() {}

	/**
	 * Creates a new property.
	 * @param key the property key.
	 */
	public GCubeElementProperty(String key) {
		this.key = key;
		
	}
	
	/**
	 * Creates a new property.
	 * @param key the property key.
	 * @param value the property value.
	 */
	public GCubeElementProperty(String key, String value) {
		this(key);
		this.value = value;
	}
	
	/**
	 * Creates a new property.
	 * @param key the property key.
	 * @param type the property type.
	 * @param value the property value.
	 */
	public GCubeElementProperty(String key, String type, String value) {
		this(key,value);
		this.type = type;
	}

	/**
	 * @return the property key
	 */
	public String key() {
		return key;
	}

	/**
	 * @return the property type
	 */
	public String type() {
		return type;
	}

	/**
	 * @param type the property type to set
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return the property value
	 */
	public String value() {
		return value;
	}

	/**
	 * @param value the property value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

	
	/**
	 * {@inheritDoc}
	 */ 
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("[key=");
		builder.append(key);
		builder.append(", type=");
		builder.append(type);
		builder.append(", value=");
		builder.append(value);
		builder.append("]");
		return builder.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((key == null) ? 0 : key.hashCode());
		result = prime * result + ((type == null) ? 0 : type.hashCode());
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof GCubeElementProperty))
			return false;
		GCubeElementProperty other = (GCubeElementProperty) obj;
		if (key == null) {
			if (other.key != null)
				return false;
		} else if (!key.equals(other.key))
			return false;
		if (type == null) {
			if (other.type != null)
				return false;
		} else if (!type.equals(other.type))
			return false;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}
	
	

}
