/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.client;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.util.UUID;
import org.gcube.common.homelibrary.client.FTPClient;
import org.gcube.common.homelibrary.client.FTPFile;

public class Test {
    public static void main(String[] args) throws Exception {
        FTPFile[] mylist;
        FTPFile[] list;
        FTPClient client = new FTPClient();
        System.out.println("Current dir " + client.getRootPath());
        System.out.println("List Root ");
        for (FTPFile item : list = client.list(client.getRootPath())) {
            System.out.println("* " + item.getName() + " is folder? " + item.isFolder());
            if (!item.getName().startsWith("A-")) continue;
            client.delete(item.getPath());
        }
        System.out.println("\n\n");
        String A_name = "A-" + UUID.randomUUID().toString();
        String B_name = "B-" + UUID.randomUUID().toString();
        client.createDirectory(A_name, "test A in ROOT", client.getRootPath());
        System.out.println("Folder " + A_name + " created in " + client.getRootPath());
        System.out.println("\n\n");
        client.createDirectory(B_name, "test A in ROOT", "/Share/042efb85-240b-4a04-93d3-bca3924b7503/" + A_name);
        System.out.println("Folder " + B_name + " created in " + client.getRootPath());
        System.out.println("\n\n");
        System.out.println("Save images in /Share/042efb85-240b-4a04-93d3-bca3924b7503/" + A_name + "/" + B_name);
        URL imageURL = Test.class.getClassLoader().getResource("org/gcube/common/homelibrary/client/2016-05-05_2016-05-05_16_04.jpg");
        File file = new File(imageURL.getFile());
        for (int i = 0; i < 5; ++i) {
            byte[] image = Files.readAllBytes(file.toPath());
            client.upload(image, "img-" + UUID.randomUUID().toString() + ".jpg", "my description", "/Share/042efb85-240b-4a04-93d3-bca3924b7503/" + A_name + "/" + B_name, "image/jpeg", 3000L);
        }
        System.out.println("\n\n");
        System.out.println("List Folder ");
        for (FTPFile item : mylist = client.list("/Share/042efb85-240b-4a04-93d3-bca3924b7503/" + A_name)) {
            System.out.println("* " + item.getName() + " is folder? " + item.isFolder());
        }
        System.out.println("\n\n");
        System.out.println("HL CLI test successfully completed. ");
    }
}

