package org.gcube.common.homelibrary.client;

public class FTPFile {

	private String path;
	private Boolean isFolder;

	public FTPFile(String path, Boolean isFolder) {
		this.path = path;
		this.isFolder = isFolder;
	}

	/**
	 * Get folder path
	 * @return the path
	 */
	public String getPath() {
		return path;
	}

	/**
	 * This methods returs true if the current file is a folder
	 * @return true if the file is a folder, false otherwise
	 */
	public Boolean isFolder() {
		return isFolder;
	}
	
	/**
	 * This methods returs the name of the current file or folder
	 * @return the name of the current file or folder
	 */
	public String getName() {
		int index = getPath().lastIndexOf("/");
		String fileName = getPath().substring(index + 1);
		return fileName;
	}

}
