/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetItemById
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetItemById.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String id = request.getParameter("id");
        String login = request.getParameter("login");
        logger.info("Servlet GetItemById called with parameters: [id: " + id + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        ItemDelegate item = null;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
            try {
                item = this.getDelegateItemById(session, id, login);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            xmlConfig = xstream.toXML((Object)item);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            logger.error("Error repository ex " + (Object)((Object)e));
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }

    private ItemDelegate getDelegateItemById(SessionImpl session, String identifier, String login) throws Exception {
        Node node = session.getNodeByIdentifier(identifier);
        NodeManager wrap = new NodeManager(node, login);
        ItemDelegate item = null;
        try {
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }
}

