/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import java.util.HashMap;
import java.util.Set;
import org.apache.jackrabbit.core.SessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Cleaner
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(Cleaner.class);
    private HashMap<String, SessionImpl> list;

    public Cleaner(HashMap<String, SessionImpl> list) {
        this.list = list;
    }

    @Override
    public void run() {
        while (true) {
            logger.info("Running Session Cleaner..");
            logger.info("Active sessions: " + this.list.size());
            try {
                Set keys = this.list.keySet();
                for (String key : keys) {
                    SessionImpl session = (SessionImpl)this.list.get(key);
                    if (session.isLive()) continue;
                    logger.info(String.valueOf(key) + " is not usable anymore, will be removed from the cache");
                    this.list.remove(key);
                }
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Session Cleaner interrupted.");
                continue;
            }
            break;
        }
    }
}

