/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.lock;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockSession
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(LockSession.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String uuid = request.getParameter("uuid");
        String id = request.getParameter("id");
        String user = request.getParameter("adminId");
        String pass = request.getParameter("adminPassword");
        logger.info("Servlet LockSession called with parameters: [uuid: " + uuid + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionManager sessionManager = null;
        XStream xstream = null;
        String xmlConfig = null;
        Object children = null;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getSessions((Repository)rep);
                if (!sessionManager.sessionExists(uuid)) {
                    SessionImpl session = sessionManager.newSession(user, pass.toCharArray());
                    LockManager lockManager = session.getWorkspace().getLockManager();
                    Lock lock = lockManager.lock(session.getNodeByIdentifier(id).getPath(), true, true, 0L, "");
                    logger.trace("LOCK on Node: " + lock.getNode().getPath());
                    session.save();
                    logger.info("Getting new session, with uuid " + uuid + ", lock node with id " + id);
                }
                xmlConfig = xstream.toXML(children);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                out.close();
                out.flush();
            }
        }
        finally {
            out.close();
            out.flush();
        }
    }
}

