/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchItems
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(SearchItems.class);
    public static final String PATH_SEPARATOR = "/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    public static final String USERS = "hl:users";
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String query = request.getParameter("query");
        String lang = request.getParameter("lang");
        String login = request.getParameter("login");
        logger.info("Servlet SearchItems called with parameters: [query: " + query + " - lang: " + lang + " - login: " + login + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        List children = null;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
                children = this.execute(session, query, lang, login);
                xmlConfig = xstream.toXML((Object)children);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                if (session != null) {
                    session.logout();
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }

    private List<ItemDelegate> execute(SessionImpl session, String query, String lang, String login) throws Exception {
        LinkedList<ItemDelegate> list = null;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        try {
            Query q = null;
            if (lang.equals("JCR-SQL2")) {
                q = queryManager.createQuery(query, "JCR-SQL2");
            } else if (lang.equals("xpath")) {
                q = queryManager.createQuery(query, "xpath");
            } else if (lang.equals("sql")) {
                q = queryManager.createQuery(query, "sql");
            } else if (lang.equals("JCR_JQOM")) {
                q = queryManager.createQuery(query, "JCR-JQOM");
            } else {
                logger.error("lang unknown");
            }
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            list = new LinkedList<ItemDelegate>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                String itemName = this.isValidSearchResult(node, login);
                if (itemName == null) {
                    logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                NodeManager wrap = new NodeManager(node, login);
                try {
                    ItemDelegate item = wrap.getItemDelegate();
                    list.add(item);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public String isValidSearchResult(Node node, String login) {
        String sharePath = "/Share";
        String userPath = "/Home/" + login;
        try {
            String nodePath = node.getPath();
            if (nodePath.startsWith(userPath)) {
                return node.getProperty(NodeProperty.TITLE.toString()).getString();
            }
            if (nodePath.startsWith(sharePath)) {
                Node sharedNode = (Node)node.getAncestor(2);
                if (node.getPath().equals(sharedNode.getPath())) {
                    Node usersNode = sharedNode.getNode(NodeProperty.USERS.toString());
                    String prop = usersNode.getProperty(login).getValue().getString();
                    String[] value = prop.split(PATH_SEPARATOR);
                    return value[1];
                }
                return node.getName();
            }
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }
}

